DECLARE
CURSOR loc_cur IS SELECT id,vista_facility,location_code 
                  FROM temp_location 
                  ORDER by id
                  FOR UPDATE; 
loc_rec loc_cur%rowtype;
myFacility varchar2(255);
   
BEGIN 
    IF NOT loc_cur%ISOPEN THEN
      OPEN loc_cur;
    END IF;
    LOOP
        FETCH loc_cur INTO loc_rec;
        EXIT WHEN loc_cur%NOTFOUND;

      IF loc_rec.vista_facility is not null THEN
        myFacility := loc_rec.vista_facility;
      END IF:
        
	update temp_location set vista_facility = trim(myFacility) WHERE CURRENT OF loc_cur;
    END LOOP;
END;
/