/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * 
 * @author vhaislegberb
 */
@Entity
@Table(name = "PURPOSE_OF_USE")
@NamedQueries({
		@NamedQuery(name = "PurposeOfUse.findAll", query = "SELECT p FROM PurposeOfUse p"),
		@NamedQuery(name = "PurposeOfUse.findByPouId", query = "SELECT p FROM PurposeOfUse p WHERE p.pouId = :pouId"),
		@NamedQuery(name = "PurposeOfUse.findByPouValue", query = "SELECT p FROM PurposeOfUse p WHERE p.pouValue = :pouValue"),
		@NamedQuery(name = "PurposeOfUse.findByUrn", query = "SELECT p FROM PurposeOfUse p WHERE p.urn = :urn") })
public class PurposeOfUse implements Serializable {
	private static final long serialVersionUID = 1L;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "POU_ID")
	private Long pouId;
	@Basic(optional = false)
	@Column(name = "POU_VALUE")
	private String pouValue;
	@Basic(optional = false)
	@Column(name = "URN")
	private String urn;

	public PurposeOfUse() {
	}

	public PurposeOfUse(final Long pouId) {
		this.pouId = pouId;
	}

	public PurposeOfUse(final Long pouId, final String pouValue,
			final String urn) {
		this.pouId = pouId;
		this.pouValue = pouValue;
		this.urn = urn;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof PurposeOfUse)) {
			return false;
		}
		final PurposeOfUse other = (PurposeOfUse) object;
		if (((this.pouId == null) && (other.pouId != null))
				|| ((this.pouId != null) && !this.pouId.equals(other.pouId))) {
			return false;
		}
		return true;
	}

	public Long getPouId() {
		return this.pouId;
	}

	public String getPouValue() {
		return this.pouValue;
	}

	public String getUrn() {
		return this.urn;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.pouId != null ? this.pouId.hashCode() : 0);
		return hash;
	}

	public void setPouId(final Long pouId) {
		this.pouId = pouId;
	}

	public void setPouValue(final String pouValue) {
		this.pouValue = pouValue;
	}

	public void setUrn(final String urn) {
		this.urn = urn;
	}

	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.PurposeOfUse[pouId="
				+ this.pouId + "]";
	}

}
