/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * 
 * @author vhaislegberb
 */
@Entity
@Table(name = "PATIENT_DOCUMENT")
@NamedQueries({
		@NamedQuery(name = "PatientDocument.findAll", query = "SELECT p FROM PatientDocument p"),
		@NamedQuery(name = "PatientDocument.findByDocumentId", query = "SELECT p FROM PatientDocument p WHERE p.documentId = :documentId"),
		@NamedQuery(name = "PatientDocument.findByConsentDir", query = "SELECT p FROM PatientDocument p WHERE p.consentDirective = :consentDirective"),
		@NamedQuery(name = "PatientDocument.findByConsentDirAndType", query = "SELECT p FROM PatientDocument p WHERE p.consentDirective = :consentDirective and p.patientDocumentType = :patientDocumentType"),
        @NamedQuery(name = "PatientDocument.findByExternalDocumentId", query = "SELECT p FROM PatientDocument p WHERE p.externalDocumentId = :externalDocumentId")})
public class PatientDocument implements Serializable {
	private static final long serialVersionUID = 1L;
	@ManyToOne(optional = false)
	@JoinColumn(name = "CONSENT_DIR_ID", referencedColumnName = "CONSENT_DIR_ID")
	private ConsentDirective consentDirective;
	@Basic(optional = false)
	@Lob
	@Column(name = "DOCUMENT")
	private Serializable document;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "DOCUMENT_ID")
	private Long documentId;
	@JoinColumn(name = "TYPE", referencedColumnName = "DOCUMENT_TYPE_ID")
	@ManyToOne(optional = false)
	private PatientDocumentType patientDocumentType;
    @Column(name = "EXTERNAL_DOCUMENT_ID")
	private String externalDocumentId;
	
	public PatientDocument() {
	}

	public PatientDocument(final Long documentId) {
		this.documentId = documentId;
	}

	public PatientDocument(final Long documentId, final Serializable pdf) {
		this.documentId = documentId;
		this.document = pdf;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof PatientDocument)) {
			return false;
		}
		final PatientDocument other = (PatientDocument) object;
		if (((this.documentId == null) && (other.documentId != null))
				|| ((this.documentId != null) && !this.documentId
						.equals(other.documentId))) {
			return false;
		}
		return true;
	}

	public ConsentDirective getConsentDirective() {
		return this.consentDirective;
	}

	public Serializable getDocument() {
		return this.document;
	}

	public Long getDocumentId() {
		return this.documentId;
	}

	public PatientDocumentType getPatientDocumentType() {
		return this.patientDocumentType;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.documentId != null ? this.documentId.hashCode() : 0);
		return hash;
	}

	public void setConsentDirective(final ConsentDirective consentDirective) {
		this.consentDirective = consentDirective;
	}

	public void setDocument(final Serializable document) {
		this.document = document;
	}

	public void setDocumentId(final Long documentId) {
		this.documentId = documentId;
	}

	public void setPatientDocumentType(
			final PatientDocumentType patientDocumentType) {
		this.patientDocumentType = patientDocumentType;
	}

	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.PatientDocument[documentId="
				+ this.documentId + "]";
	}

	public String getExternalDocumentId() {
		return externalDocumentId;
	}

	public void setExternalDocumentId(String externalDocumentId) {
		this.externalDocumentId = externalDocumentId;
	}

}
