/*
 * DTO for PATIENT_CONFIDENTIALITY table
 */
package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * CREATE TABLE vap.PATIENT_CONFIDENTIALITY (PATIENT_CONFIDENTIALITY_ID int not null, PATIENT_ICN varchar2(255) not null, CONFIDENTIALITY_CODE varchar2(255) not null, STORED_TS date, constraint "PK_PATIENT_CONFIDENTIALITY" primary key(PATIENT_CONFIDENTIALITY_ID), CONSTRAINT "UK_PAT_CONF_PATIENT_ICN" UNIQUE(PATIENT_ICN));
 * 
 * 
 * @author John W. May
 */
@Entity
@Table(name = "PATIENT_CONFIDENTIALITY")
@NamedQueries({
    @NamedQuery(name = "PatientConfidentiality.findAll", query = "SELECT d FROM PatientConfidentiality d"),
    @NamedQuery(name = "PatientConfidentiality.findByPatientConfidentialityId", query = "SELECT d FROM PatientConfidentiality d WHERE d.patientConfidentialityId = :patientConfidentialityId"),
    @NamedQuery(name = "PatientConfidentiality.findByPatientIcn", query = "SELECT d FROM PatientConfidentiality d WHERE d.patientIcn = :patientIcn"),
    @NamedQuery(name = "PatientConfidentiality.findByPatientIcnAndMaxAgeLimit", query = "SELECT d FROM PatientConfidentiality d WHERE d.patientIcn = :patientIcn and d.storedTS > :maxAgeLimitTS"),
    @NamedQuery(name = "PatientConfidentiality.findByPatientIcnAndMaxAgeLimitByConfidentialCode", query = "SELECT d FROM PatientConfidentiality d WHERE (d.patientIcn = :patientIcn and d.confidentialityCode = gov.va.nvap.svc.consentmgmt.stub.data.ConfidentialityCodeType.NORMAL and d.storedTS > :maxAgeLimitForNormalTS) OR (d.patientIcn = :patientIcn and d.confidentialityCode = gov.va.nvap.svc.consentmgmt.stub.data.ConfidentialityCodeType.RESTRICTED and d.storedTS > :maxAgeLimitForRestrictedTS)")
})  
public class PatientConfidentiality implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "PATIENT_CONFIDENTIALITY_ID")
    private Long patientConfidentialityId;

    @Basic(optional = false)
    @Column(name = "PATIENT_ICN", unique = true)
    private String patientIcn;

    @Basic(optional = false)
    @Column(name = "CONFIDENTIALITY_CODE")
    @Enumerated(EnumType.STRING)
    private ConfidentialityCodeType confidentialityCode;

    @Basic(optional = false)
    @Column(name = "STORED_TS")
    @Temporal(TemporalType.TIMESTAMP)
    private Date storedTS;

    public PatientConfidentiality() {
    }

    public PatientConfidentiality(Long patientConfidentialityId) {
        this.patientConfidentialityId = patientConfidentialityId;
    }

    public PatientConfidentiality(Long patientConfidentialityId, String patientIcn, ConfidentialityCodeType confidentialityCode, Date storedTS) {
        this.patientConfidentialityId = patientConfidentialityId;
        this.patientIcn = patientIcn;
        this.confidentialityCode = confidentialityCode;
        this.storedTS = storedTS;
    }

    public Long getPatientConfidentialityId() {
        return patientConfidentialityId;
    }

    public void setPatientConfidentialityId(Long patientConfidentialityId) {
        this.patientConfidentialityId = patientConfidentialityId;
    }

    public String getPatientIcn() {
        return patientIcn;
    }

    public void setPatientIcn(String patientIcn) {
        this.patientIcn = patientIcn;
    }

    public ConfidentialityCodeType getConfidentialityCode() {
        return confidentialityCode;
    }

    public void setConfidentialityCode(ConfidentialityCodeType confidentialityCode) {
        this.confidentialityCode = confidentialityCode;
    }

    public Date getStoredTS() {
        return storedTS;
    }

    public void setStoredTS(Date storedTS) {
        this.storedTS = storedTS;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (patientConfidentialityId != null ? patientConfidentialityId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof PatientConfidentiality)) {
            return false;
        }
        PatientConfidentiality other = (PatientConfidentiality) object;
        if ((this.patientConfidentialityId == null && other.patientConfidentialityId != null) || (this.patientConfidentialityId != null && !this.patientConfidentialityId.equals(other.patientConfidentialityId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.PatientConfidentiality[ id=" + this.patientConfidentialityId + " ]";
    }

}
