/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * 
 * @author vhaislegberb
 */
@Entity
@Table(name = "ALLOWED_ORG")
@NamedQueries({
		@NamedQuery(name = "Organization.findAll", query = "SELECT o FROM Organization o"),
		@NamedQuery(name = "Organization.findByOrgId", query = "SELECT o FROM Organization o WHERE o.orgId = :orgId"),
		@NamedQuery(name = "Organization.findByOrgOid", query = "SELECT o FROM Organization o WHERE o.orgOid = :orgOid"),
		@NamedQuery(name = "Organization.findByOrgName", query = "SELECT o FROM Organization o WHERE o.orgName = :orgName"),
		@NamedQuery(name = "Organization.findByOrgContact", query = "SELECT o FROM Organization o WHERE o.orgContact = :orgContact"),
		@NamedQuery(name = "Organization.findByOorgPhoneNumber", query = "SELECT o FROM Organization o WHERE o.oorgPhoneNumber = :oorgPhoneNumber"),
		@NamedQuery(name = "Organization.findByActive", query = "SELECT o FROM Organization o WHERE o.active = :active order by lower(o.orgName)"),
		@NamedQuery(name = "Organization.findByActiveOrgConsumerOnly", query = "SELECT o FROM Organization o WHERE o.active = :active AND o.orgConsumerOnly = :orgConsumerOnly order by lower(o.orgName)"),
        @NamedQuery(name = "Organization.getIsTrustedClinicalSource", query = "SELECT o.isTrustedClinicalSource FROM Organization o WHERE o.orgOid = :organizationId")})
public class Organization implements Serializable {
	private static final long serialVersionUID = 1L;

	@Column(name = "ORG_PHONE_NUMBER")
	private String oorgPhoneNumber;
	@Column(name = "ORG_COMMUNITY_ID_PREFIX")
	@Basic(optional = false)
	private String orgCommunityIdPrefix;
	@Column(name = "ORG_CONTACT")
	private String orgContact;
	@Column(name = "ORG_DOMAIN")
	@Basic(optional = false)
	private String orgDomain;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "ORG_ID")
	private Long orgId;
	@Basic(optional = false)
	@Column(name = "ORG_NAME")
	private String orgName;
	@Column(name = "ORG_NUMBER")
	@Basic(optional = false)
	private String orgNumber;
	@Basic(optional = false)
	@Column(name = "ORG_OID")
	private String orgOid;
	@Basic(optional = false)
	@Column(name = "ORG_CONSUMER_ONLY")
	private char orgConsumerOnly;
	@Basic(optional = false)
	@Column(name = "ACTIVE")
	private char active;
    @Basic(optional = false)
	@Column(name = "IS_TRUSTED_CLINICAL_SOURCE")
	private char isTrustedClinicalSource;
    
	public Organization() {
	}

	public Organization(final Long orgId) {
		this.orgId = orgId;
	}

	public Organization(final Long orgId, final String orgNumber,
			final String orgOid, final String orgName, final String orgDomain,
			final String orgCommunityIdPrefix, final char active, final char orgConsumerOnly, final char isTrustedClinicalSource) {
		this.orgId = orgId;
		this.orgNumber = orgNumber;
		this.orgOid = orgOid;
		this.orgName = orgName;
		this.orgDomain = orgDomain;
		this.orgCommunityIdPrefix = orgCommunityIdPrefix;
		this.orgConsumerOnly = orgConsumerOnly;
		this.active = active;
        this.isTrustedClinicalSource = isTrustedClinicalSource;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof Organization)) {
			return false;
		}
		final Organization other = (Organization) object;
		if (((this.orgId == null) && (other.orgId != null))
				|| ((this.orgId != null) && !this.orgId.equals(other.orgId))) {
			return false;
		}
		return true;
	}

	public boolean isOrgConsumerOnly() {
		return (Character.toUpperCase(getOrgConsumerOnly()) == 'Y');
	}
	
	public char getOrgConsumerOnly() {
		return this.orgConsumerOnly;
	}
    
	public char getIsTrustedClinicalSource() {
		return this.isTrustedClinicalSource;
	}
	
	public char getActive() {
		return this.active;
	}

	public String getOorgPhoneNumber() {
		return this.oorgPhoneNumber;
	}

	public String getOrgCommunityIdPrefix() {
		return this.orgCommunityIdPrefix;
	}

	public String getOrgContact() {
		return this.orgContact;
	}

	public String getOrgDomain() {
		return this.orgDomain;
	}

	public Long getOrgId() {
		return this.orgId;
	}

	public String getOrgName() {
		return this.orgName;
	}

	public String getOrgNumber() {
		return this.orgNumber;
	}

	public String getOrgOid() {
		return this.orgOid;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.orgId != null ? this.orgId.hashCode() : 0);
		return hash;
	}

	public void setOrgConsumerOnly(final char orgConsumerOnly) {
		this.orgConsumerOnly = orgConsumerOnly;
	}
    
    public void setIsTrustedClinicalSource(final char isTrustedClinicalSource) {
		this.isTrustedClinicalSource = isTrustedClinicalSource;
	}
	
	public void setActive(final char active) {
		this.active = active;
	}

	public void setOrgCommunityIdPrefix(final String orgCommunityIdPrefix) {
		this.orgCommunityIdPrefix = orgCommunityIdPrefix;
	}

	public void setOrgContact(final String orgContact) {
		this.orgContact = orgContact;
	}

	public void setOrgDomain(final String orgDomain) {
		this.orgDomain = orgDomain;
	}

	public void setOrgId(final Long orgId) {
		this.orgId = orgId;
	}

	public void setOrgName(final String orgName) {
		this.orgName = orgName;
	}

	public void setOrgNumber(final String orgNumber) {
		this.orgNumber = orgNumber;
	}

	public void setOrgOid(final String orgOid) {
		this.orgOid = orgOid;
	}

	public void setOrgPhoneNumber(final String oorgPhoneNumber) {
		this.oorgPhoneNumber = oorgPhoneNumber;
	}
    
	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.Organization[orgId="
				+ this.orgId + "]";
	}
}
