package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 *
 * @since 06/02/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "MAIL_TEMPLATE")
public class MailTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "MAIL_TEMPLATE_ID")
    private Long mailTemplateId;
    
    @Basic(optional = false)
    @Column(name = "LETTER_TYPE_ID")
    private Long letterTypeId;
    
    @Basic(optional = false)
    @Column(name = "TEXT")
    private String text;

    public Long getMailTemplateId() {
        return mailTemplateId;
    }

    public void setMailTemplateId(Long mailTemplateId) {
        this.mailTemplateId = mailTemplateId;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getLetterType() {
        return letterTypeId;
    }

    public void setLetterType(Long letterTypeId) {
        this.letterTypeId = letterTypeId;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (mailTemplateId != null ? mailTemplateId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the mailTemplateId fields are not set
        if (!(object instanceof MailTemplate)) {
            return false;
        }
        MailTemplate other = (MailTemplate) object;
        if ((this.mailTemplateId == null && other.mailTemplateId != null) || (this.mailTemplateId != null && !this.mailTemplateId.equals(other.mailTemplateId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.MailTemplate[ id=" + mailTemplateId + " ]";
    }

}
