package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * @since 04/06/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "MAIL_NOTIFICATION")
@NamedQueries({
    @NamedQuery(name = "MailNotification.findAll", query = "SELECT m FROM MailNotification m"),
    @NamedQuery(name = "MailNotification.findByConsentDirId", query = "SELECT m FROM MailNotification m WHERE m.consentDirId = :consentDirId"),
    @NamedQuery(name = "MailNotification.findByDelayedConsentId", query = "SELECT m FROM MailNotification m WHERE m.delayedConsentId = :delayedConsentId"),
    @NamedQuery(name = "MailNotification.findByMailNotificationId", query = "SELECT m FROM MailNotification m WHERE m.mailNotificationId = :mailNotificationId"),
    @NamedQuery(name = "MailNotification.findBySentDate", query = "SELECT m FROM MailNotification m WHERE m.sentDate = :sentDate"),
    @NamedQuery(name = "MailNotification.findByUserId", query = "SELECT m FROM MailNotification m WHERE m.userId = :userId")})
public class MailNotification implements Serializable {

    @JoinColumn(name = "DELAYED_CONSENT_ID", referencedColumnName = "DELAYED_CONSENT_ID")
    @ManyToOne
    private DelayedConsent delayedConsentId;
    @JoinColumn(name = "CONSENT_DIR_ID", referencedColumnName = "CONSENT_DIR_ID")
    @ManyToOne
    private ConsentDirective consentDirId;

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "MAIL_NOTIFICATION_ID")
    private Long mailNotificationId;
    @Basic(optional = false)
    @Column(name = "SENT_DATE")
    @Temporal(TemporalType.DATE)
    private Date sentDate;
    @Basic(optional = false)
    @Column(name = "USER_ID")
    private String userId;

    public MailNotification() {
    }

    public MailNotification(Long mailNotificationId) {
        this.mailNotificationId = mailNotificationId;
    }

    public MailNotification(Long mailNotificationId, Date sentDate, String userId) {
        this.mailNotificationId = mailNotificationId;
        this.sentDate = sentDate;
        this.userId = userId;
    }

    public Long getMailNotificationId() {
        return mailNotificationId;
    }

    public void setMailNotificationId(Long mailNotificationId) {
        this.mailNotificationId = mailNotificationId;
    }

    public Date getSentDate() {
        return sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (mailNotificationId != null ? mailNotificationId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof MailNotification)) {
            return false;
        }
        MailNotification other = (MailNotification) object;
        if ((this.mailNotificationId == null && other.mailNotificationId != null) || (this.mailNotificationId != null && !this.mailNotificationId.equals(other.mailNotificationId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.MailNotification[ mailNotificationId=" + mailNotificationId + " ]";
    }

    public DelayedConsent getDelayedConsentId() {
        return delayedConsentId;
    }

    public void setDelayedConsentId(DelayedConsent delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public ConsentDirective getConsentDirId() {
        return consentDirId;
    }

    public void setConsentDirId(ConsentDirective consentDirId) {
        this.consentDirId = consentDirId;
    }

}
