package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 *
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "MAIL_LOG")
public class MailLog implements Serializable {

    private static final long serialVersionUID = 1L;
    
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "LOG_ID")
    private Long mailLogId;
    
    @Basic(optional = false)
    @Column(name = "LOG_ENTRY")
    private String logEntry;
    
    @Basic(optional = true)
    @Column(name = "DELAYED_CONSENT_ID")
    private Long delayedConsentId;
    
    @Basic(optional = true)
    @Column(name = "CONSENT_DIR_ID")
    private Long consentDirId;
    
    public Long getMailLogId() {
        return mailLogId;
    }

    public void setMailLogId(Long mailLogId) {
        this.mailLogId = mailLogId;
    }
    
    public String getLogEntry() {
        return logEntry;
    }
    
    public void setLogEntry(String logEntry) {
        this.logEntry = logEntry;
    }

    public Long getDelayedConsentId() {
        return delayedConsentId;
    }

    public void setDelayedConsentId(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public Long getConsentDirId() {
        return consentDirId;
    }

    public void setConsentDirId(Long consentDirId) {
        this.consentDirId = consentDirId;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (mailLogId != null ? mailLogId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof MailLog)) {
            return false;
        }
        MailLog other = (MailLog) object;
        if ((this.mailLogId == null && other.mailLogId != null) || (this.mailLogId != null && !this.mailLogId.equals(other.mailLogId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.MailLog[ mailLogId=" + mailLogId + " ]";
    }
    
}
