package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @since 06/02/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "LETTER_TYPE")
public class LetterType implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "LETTER_TYPE_ID")
    private Long letterTypeId;

    @Basic(optional = false)
    @Column(name = "NAME")
    private String name;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "LetterType")
    private Collection<MailTemplate> mailTemplateCollection;
    
    public Long getLetterTypeId() {
        return letterTypeId;
    }

    public void setLetterTypeId(Long letterTypeId) {
        this.letterTypeId = letterTypeId;
    }
    
    public Collection<MailTemplate> getMailTemplateCollection() {
        return this.mailTemplateCollection;
    }

    public void setMailTemplateCollection(Collection<MailTemplate> mailTemplateCollection) {
        this.mailTemplateCollection = mailTemplateCollection;
    }
    
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (letterTypeId != null ? letterTypeId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the letterTypeId fields are not set
        if (!(object instanceof LetterType)) {
            return false;
        }
        LetterType other = (LetterType) object;
        if ((this.letterTypeId == null && other.letterTypeId != null) || (this.letterTypeId != null && !this.letterTypeId.equals(other.letterTypeId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.LetterType[ id=" + letterTypeId + " ]";
    }

}
