package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Zack Peterson
 * @author vhaislegberb
 */
@Entity
@Table(name = "PATIENT_CONSENT_DIR")
@NamedNativeQueries({
    @NamedNativeQuery(
            name="FacilityOptInConsent.findAuthorizedConsentInformation",
            query=FacilityOptInConsent.findExpiringConsentDirectivesForSummaryNativeSQL,
            resultClass=FacilityOptInConsent.class
    )
})

public class FacilityOptInConsent implements Serializable {
	private static final long serialVersionUID = 1L;

    protected static final String findExpiringConsentDirectivesForSummaryNativeSQL=
    " select  "+       
"  ROW_NUMBER() OVER(order by lower(f.FACILITY_NAME)) id , NVL(to_char(f.facility_name), 'Unknown') as facility_name, p.optin_consent_type_id,count(1) total, count( case  WHEN (PATIENT_SSN NOT LIKE '000%' AND PATIENT_SSN NOT LIKE '666%'AND  PATIENT_SSN NOT LIKE '9%' AND PATIENT_SSN NOT LIKE '%0000' AND PATIENT_SSN NOT LIKE '___00____') or PATIENT_SSN is null then 1 end)" +
"   real" +
"	from patient_consent_dir p, consent_type c, consent_audit ca, facility f" +
"	where " +
"	p.optin_consent_type_id = c.consent_type_id" +
"	and p.patient_ien = ca.patient_id" +
"	and p.optout_ts is null" +
"	and p.optout_date is null" +
"	and substr(ca.facility, 1, 3) = f.facility_station(+)       " +
"       and (EXPIRATION_DATE > systimestamp)   " +
"       and CA.ACTION_TYPE = 'OPT-IN'"+
"	and ca.time_of_event = (select max(ica.time_of_event) " +
"		  from consent_audit ica" +
"		  where ica.patient_id = ca.patient_id" +
"		  and ica.consent_type = c.name" +
"      " +
"	)" +
"       GROUP BY f.FACILITY_NAME, p.optin_consent_type_id order by lower(f.FACILITY_NAME)" +
"	";

	@Id
        @GeneratedValue(strategy = GenerationType.AUTO)
        @Basic(optional = false)
        @Column(name = "ID")
        private Long id;
	@Basic(optional = false)
	@Column(name = "TOTAL")
	private Long total;
        @Basic(optional = false)
	@Column(name = "REAL")
	private Long real;
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "OPTIN_CONSENT_TYPE_ID")
	private ConsentType optinConsentType;
        @Column(name = "FACILITY_NAME")
        private String facilityName;

    

    

	public FacilityOptInConsent() {
	}

	

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof FacilityOptInConsent)) {
			return false;
		}
		final FacilityOptInConsent other = (FacilityOptInConsent) object;
		if (((this.facilityName == null) && (other.facilityName != null))
				|| ((this.facilityName != null) && !this.facilityName
						.equals(other.facilityName))) {
			return false;
		}
                if (((this.optinConsentType == null) && (other.optinConsentType != null))
				|| ((this.optinConsentType != null) && !this.optinConsentType
						.equals(other.optinConsentType))) {
			return false;
		}
		return true;
	}

	
	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.facilityName != null ? this.facilityName.hashCode() : 0);
                hash += (this.optinConsentType != null ? this.optinConsentType.hashCode() : 0);
		return hash;
	}

	
	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.DetailedConsentDirective[facilityName="
				+ this.facilityName + "]";
	}

	public void setOptinConsentType(ConsentType optinConsentType) {
		this.optinConsentType = optinConsentType;
	}

	public ConsentType getOptinConsentType() {
		return optinConsentType;
	}

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Long getReal() {
        return real;
    }
    
    public void setReal(Long real) {
        this.real = real;
    }
        public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }
    
    public Long getTest() {
        return total-real;
    }
}
