/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author vhaislegberb
 */
@Entity
@Table(name = "FACILITY")
@NamedQueries({
    @NamedQuery(name = "Facility.findAll", query = "SELECT f FROM Facility f ORDER BY lower(f.facilityName)"),
    @NamedQuery(name = "Facility.findByFacilityId", query = "SELECT f FROM Facility f WHERE f.facilityId = :facilityId"),
    @NamedQuery(name = "Facility.findByFacilityName", query = "SELECT f.facilityStation FROM Facility f WHERE f.facilityName = :facilityName"),
    @NamedQuery(name = "Facility.findByFacilityStation", query = "SELECT f FROM Facility f WHERE f.facilityStation = :facilityStation"),
    @NamedQuery(name = "Facility.findByFacilityDns", query = "SELECT f FROM Facility f WHERE f.facilityDns = :facilityDns"),
    @NamedQuery(name = "Facility.findByAllowed", query = "SELECT f FROM Facility f WHERE f.allowed = :allowed order by lower(f.facilityName)")})
public class Facility implements Serializable {

    private static final long serialVersionUID = 1L;
    @Basic(optional = false)
    @Column(name = "ALLOWED")
    private boolean allowed;
    @Column(name = "FACILITY_DNS")
    private String facilityDns;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "FACILITY_ID")
    private Long facilityId;
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    @Column(name = "FACILITY_STATION")
    private String facilityStation;

    @Column(name = "FACILITY_PHONE")
    private String phone;

    @Column(name = "FACILITY_ADDRESS")
    private String address;

    @Column(name = "FACILITY_CITY")
    private String city;

    @Column(name = "FACILITY_STATE")
    private String state;

    @Column(name = "FACILITY_POSTAL_CODE")
    private String postalCode;

    public Facility() {
    }

    public Facility(final Long facilityId) {
        this.facilityId = facilityId;
    }

    public Facility(final gov.va.nvap.svc.facility.data.Facility facility) {
        this.facilityId = facility.getFacilityId();
        this.allowed = facility.getAllowed();
        this.facilityDns = facility.getFacilityDns();
        this.facilityName = facility.getFacilityName();
        this.facilityStation = facility.getFacilityStation();
        this.phone = facility.getPhone();
        this.address = facility.getAddress();
        this.city = facility.getCity();
        this.state = facility.getState();
        this.postalCode = facility.getPostalCode();
    }

    public Facility(Facility facility) {
        this.facilityId = facility.getFacilityId();
        this.allowed = facility.getAllowed();
        this.facilityDns = facility.getFacilityDns();
        this.facilityName = facility.getFacilityName();
        this.facilityStation = facility.getFacilityStation();
        this.phone = facility.getPhone();
        this.address = facility.getAddress();
        this.city = facility.getCity();
        this.state = facility.getState();
        this.postalCode = facility.getPostalCode();
    }

    @Override
    public boolean equals(final Object object) {
        // TODO: Warning - this method won't work in the case the id fields are
        // not set
        if (!(object instanceof Facility)) {
            return false;
        }
        final Facility other = (Facility) object;
        if (((this.facilityId == null) && (other.facilityId != null))
            || ((this.facilityId != null) && !this.facilityId
            .equals(other.facilityId))) {
            return false;
        }
        return true;
    }

    public Boolean getAllowed() {
        return this.allowed;
    }

    public String getFacilityDns() {
        return this.facilityDns;
    }

    public Long getFacilityId() {
        return this.facilityId;
    }

    public String getFacilityName() {
        return this.facilityName;
    }

    public String getFacilityStation() {
        return this.facilityStation;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (this.facilityId != null ? this.facilityId.hashCode() : 0);
        return hash;
    }

    public void setAllowed(final Boolean allowed) {
        this.allowed = allowed;
    }

    public void setFacilityDns(final String facilityDns) {
        this.facilityDns = facilityDns;
    }

    public void setFacilityId(final Long facilityId) {
        this.facilityId = facilityId;
    }

    public void setFacilityName(final String facilityName) {
        this.facilityName = facilityName;
    }

    public void setFacilityStation(final String facilityStation) {
        this.facilityStation = facilityStation;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.entities.Facility[facilityId="
            + this.facilityId + "]";
    }

}
