package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@Table(name = "EXP_CONSENT_CONFIG")
@NamedQueries({
		@NamedQuery(name = "ExpiringConsentConfiguration.findAll", query = "SELECT c FROM ExpiringConsentConfiguration c") })
public class ExpiringConsentConfiguration implements Serializable {
	private static final long serialVersionUID = 1L;
	@Id
	@Basic(optional = false)
	@Column(name = "CONFIG_ID")
	private Long configId;
	@Basic(optional = false)
	@Column(name = "FREQUENCY")
	private String frequency;
	@Column(name = "WINDOW")
	private Long window;
	@Column(name = "EMAIL_ADDRESSES")
	private String emailAddresses;

	public ExpiringConsentConfiguration() {
		// Since there is only a single config, hard set id to 1
		this.configId = 1L;
	}
	
	public ExpiringConsentConfiguration(String frequency, Long window, String emailAddresses) {
		// Since there is only a single config, hard set id to 1
		this.configId = 1L;
		
		this.frequency = frequency;
		this.window = window;
		this.emailAddresses = emailAddresses;
	}

	@Override
	public boolean equals(final Object object) {
		if (!(object instanceof ExpiringConsentConfiguration)) {
			return false;
		}
		final ExpiringConsentConfiguration other = (ExpiringConsentConfiguration) object;
		if (((this.configId == null) && (other.configId != null))
				|| ((this.configId != null) && !this.configId
						.equals(other.configId))) {
			return false;
		}
		return true;
	}

	public Long getConfigId() {
		return this.configId;
	}
	
	public Long getWindow() {
		return this.window;
	}
	
	public String getFrequency() {
		return this.frequency;
	}
	
	public String getEmailAddresses() {
		return this.emailAddresses;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.emailAddresses != null ? this.emailAddresses.hashCode() : 0);
		return hash;
	}

	public void setConfigId(final Long configId) {
		this.configId = configId;
	}
	
	public void setWindow(final Long window) {
		this.window = window;
	}

	public void setFrequency(final String frequency) {
		this.frequency = frequency;
	}

	public void setEmailAddresses(final String emailAddresses) {
		this.emailAddresses = emailAddresses;
	}

	@Override
	public String toString() {
		return "gov.va.nvap.svc.consentmgmt.entities.Contact[frequecy="
				+ this.frequency + "]";
	}

}