package gov.va.nvap.svc.consentmgmt.stub.data;

import gov.va.nvap.common.sql.SqlUtil;
import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.stub.dao.PatientConsentDirDAO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Zack Peterson
 * @author vhaislegberb
 * edited by Irakli Kakushadze
 * edited by Elan
 */
@Entity
@Table(name = "PATIENT_CONSENT_DIR")
@NamedNativeQueries({
    @NamedNativeQuery(
        name = "DetailedConsentDirective.findAll",
        query = DetailedConsentDirective.findAllSQL,
        resultClass = DetailedConsentDirective.class
    )    
})

public class DetailedConsentDirective implements Serializable {

    private static final long serialVersionUID = 1L;

    // Info from PATIENT_CONSENT_DIR
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "CONSENT_DIR_ID")
    private Long consentDirId;
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "OPTIN_CONSENT_TYPE_ID")
    private ConsentType optinConsentType;
    @Column(name = "EXPIRATION_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date expirationDate;
    @Basic(optional = false)
    @Column(name = "OPTIN_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date optinDate;

    // Info from CONSENT_AUDIT
    @Column(name = "PATIENT_SSN")
    private String ssn;
	@Column(name = "PATIENT_IEN")
	private String patientIen;
    @Column(name = "PATIENT_LAST_NAME")
    private String lastName;
    @Column(name = "PATIENT_GIVEN_NAME")
    private String firstName;
    @Column(name = "PATIENT_MIDDLE_NAME")
    private String middleName;
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    @Column(name = "USER_ID")
    private String userId;

    @Column(name = "TOTAL_ROWS")
    private Long totalRows;

    protected static final String findAllSQL = 
        " select * from (" +
        " select p.patient_ien, ca.patient_ssn, ca.patient_given_name, ca.patient_middle_name," +
        "   ca.patient_last_name,  p.optin_date, p.expiration_date, ca.CREATED_DATE," +
        "   ca.user_id, NVL(to_char(ca.facility_name), 'Unknown') facility_name," +
        "   p.consent_dir_id, p.optin_consent_type_id, count(1) over () TOTAL_ROWS," +
        "   row_number() over (order by /*sort*/ ca.time_of_event desc) as row_num" +
        " from patient_consent_dir p, consent_type c, consent_audit_ex ca, facility f" +
        " where (" +
            /* joins */
        "   p.optin_consent_type_id = c.consent_type_id" +
        "   and p.patient_ien = ca.patient_id" +
        "   and ca.facility = f.facility_station(+)" +
            /* pre-set conditions */
        "   and p.optout_ts is null" +
        "   and p.optout_date is null" +
        "   and ca.action_type = 'OPT-IN'" +
        "   and ca.time_of_event = (" +
        "     select max(ica.time_of_event)" +
        "     from consent_audit_ex ica" +
        "     where ica.patient_id = ca.patient_id" +
        "     and ica.consent_type = c.name" +
        "   )" +
            /* dynamic conditions */
        "   and p.optin_consent_type_id in (:ssa_consent,:eheath_consent))" +
        "   and (:user_id is null or (:user_id = 'eBenefits' and ca.user_id = 'eBenefits') or (:user_id = 'employee' and ca.user_id != 'eBenefits'))" +
        "   and ((:start_date is null and EXPIRATION_DATE > systimestamp) or EXPIRATION_DATE >= to_date(:start_date, 'YYYY-MM-DD'))" +
        "   and (:end_date is null or EXPIRATION_DATE < to_date(:end_date, 'YYYY-MM-DD'))" +
        "   /*patient_types*/" +
        "   /*station_numbers*/" +
        " )" +
        " where (row_num between :from_record and :to_record or :to_record < 0)";
    
    protected static final String findCountSQL = 
        " select count(p.CONSENT_DIR_ID)" +
        " from patient_consent_dir p, consent_type c, consent_audit_ex ca, facility f" +
        " where (" +
            /* joins */
        "   p.optin_consent_type_id = c.consent_type_id" +
        "   and p.patient_ien = ca.patient_id" +
        "   and ca.facility = f.facility_station(+)" +
            /* pre-set conditions */
        "   and p.optout_ts is null" +
        "   and p.optout_date is null" +
        "   and ca.action_type = 'OPT-IN'" +
        "   and ca.time_of_event = (" +
        "     select max(ica.time_of_event)" +
        "     from consent_audit_ex ica" +
        "     where ica.patient_id = ca.patient_id" +
        "     and ica.consent_type = c.name" +
        "   )" +
            /* dynamic conditions */
        "   and p.optin_consent_type_id in (:ssa_consent,:eheath_consent))" +
        "   and (:user_id is null or (:user_id = 'eBenefits' and ca.user_id = 'eBenefits') or (:user_id = 'employee' and ca.user_id != 'eBenefits'))" +
        "   and ((:start_date is null and EXPIRATION_DATE > systimestamp) or EXPIRATION_DATE >= to_date(:start_date, 'YYYY-MM-DD'))" +
        "   and (:end_date is null or EXPIRATION_DATE < to_date(:end_date, 'YYYY-MM-DD'))" +
        "   /*patient_types*/" +
        "   /*station_numbers*/";
    
    public static String constructQuery(String sortColumn, String sortDirection) {
        // This method needs to be depricated
        return "";
    }

    public static String constructQuery(PatientConsentDirDAO.SearchRequest req,  final HashMap<String, Object> queryParams) {
        String filter;
        String query = findAllSQL;
        String sort = "p.OPTIN_DATE desc";
        String sortOrder = "";
        String sortBy = "";

        // We cannot bind variables to column names, so we have a hardcoded default sorting clause to keep native query valid.
        // Here, we replace the sorting clause with the values received from the UI.
        if (req.sortBy == null) {
            // Don't change the default sorting.
        } else if (req.sortBy.equalsIgnoreCase("patientSsn")) {
            sortBy = "PATIENT_SSN";
        } else if (req.sortBy.equalsIgnoreCase("patientGivenName")) {
            sortBy = "lower(PATIENT_GIVEN_NAME)";
        } else if (req.sortBy.equalsIgnoreCase("patientMiddleName")) {
            sortBy = "lower(PATIENT_MIDDLE_NAME)";
        } else if (req.sortBy.equalsIgnoreCase("patientLastName")) {
            sortBy = "lower(PATIENT_LAST_NAME)";
        } else if (req.sortBy.equalsIgnoreCase("optInDate")) {
            sortBy = "OPTIN_DATE";
        } else if (req.sortBy.equalsIgnoreCase("expirationDate")) {
            sortBy = "EXPIRATION_DATE";
        } else if (req.sortBy.equalsIgnoreCase("optInConsentType")) {
            sortBy = "OPTIN_CONSENT_TYPE_ID";
        } else if (req.sortBy.equalsIgnoreCase("optInConsentTypeId")) {
            sortBy = "OPTIN_CONSENT_TYPE_ID";
        } else if (req.sortBy.equalsIgnoreCase("userId")) {
            sortBy = "lower(USER_ID)";
        } else if (req.sortBy.equalsIgnoreCase("facilityName")) {
            sortBy = "lower(f.FACILITY_NAME)";
        }
        if (req.sortBy == null) {
            // Don't change the default sorting.
        } else if (req.sortOrder.equalsIgnoreCase("ASC")) {
            sortOrder = "ASC";
        } else if (req.sortOrder.equalsIgnoreCase("DESC")) {
            sortOrder = "DESC";
        }
        if (!sortBy.isEmpty() && !sortOrder.isEmpty()) {
            sort = sortBy + " " + sortOrder;
        }
        query = query.replace("/*sort*/", sort + ",");

        query = query.replace("/*patient_types*/", SqlUtil.generatePatientsClauseSQL("ca", "PATIENT_SSN", req.patientTypes, true));

        filter = "";
        
		if ("ALL".equals(req.stationNumbers)) {
            if (req.includeUnknownVisn) {
                // User chose to include everything, so there's no need for the WHERE clause
            } else {
                // User chose to see everything BUT unknown VISN
                filter = "and f.VISN_ID is not null";
            }
        } else if (NullChecker.isNullOrEmpty(req.stationNumbers)) {
            if (req.includeUnknownVisn) {
                // User chose to see unknown VISN only
                filter = "and f.VISN_ID is null";
            } else {
                // This should never be the case
            }            
        } else {
			if (req.includeUnknownVisn) {
                // User chose to see selected station numbers AND unknown VISN
				 filter = "and (ca.facility in (:stationNumbers) or f.VISN_ID is null)";
			} else {
                // User chose to see selected stations only
				filter = "and ca.facility in (:stationNumbers)";
			}
            List<String> stationNumbers = Arrays.asList(req.stationNumbers.split(","));
            queryParams.put("stationNumbers", stationNumbers);
		}
        query = query.replace("/*station_numbers*/", filter);

        return query;
    }
    
    public static String constructCountQuery(PatientConsentDirDAO.SearchRequest req,  final HashMap<String, Object> queryParams) {
        String filter;
        String query = findCountSQL;

        query = query.replace("/*patient_types*/", SqlUtil.generatePatientsClauseSQL("ca", "PATIENT_SSN", req.patientTypes, true));

        filter = "";
        
		if ("ALL".equals(req.stationNumbers)) {
            if (req.includeUnknownVisn) {
                // User chose to include everything, so there's no need for the WHERE clause
            } else {
                // User chose to see everything BUT unknown VISN
                filter = "and f.VISN_ID is not null";
            }
        } else if (NullChecker.isNullOrEmpty(req.stationNumbers)) {
            if (req.includeUnknownVisn) {
                // User chose to see unknown VISN only
                filter = "and f.VISN_ID is null";
            } else {
                // This should never be the case
            }            
        } else {
			if (req.includeUnknownVisn) {
                // User chose to see selected station numbers AND unknown VISN
				 filter = "and (ca.facility in (:stationNumbers) or f.VISN_ID is null)";
			} else {
                // User chose to see selected stations only
				filter = "and ca.facility in (:stationNumbers)";
			}
            List<String> stationNumbers = Arrays.asList(req.stationNumbers.split(","));
            queryParams.put("stationNumbers", stationNumbers);
		}
        query = query.replace("/*station_numbers*/", filter);

        return query;
    }
    
    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

	public String getPatientIen() {
		return this.patientIen;
	}

	public void setPatientIen(final String patientIen) {
		this.patientIen = patientIen;
	}

    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DetailedConsentDirective() {
    }

    public DetailedConsentDirective(final Long consentDirId) {
        this.consentDirId = consentDirId;
    }

    public DetailedConsentDirective(final Long consentDirId, final String patientIen,
        final Date optinDate, final Date expirationDate,
        final Date optinTS, final ConsentType consentType) {
        this.consentDirId = consentDirId;
        this.optinDate = optinDate;
        this.expirationDate = expirationDate;
        this.optinConsentType = consentType;
    }

    @Override
    public boolean equals(final Object object) {
  // TODO: Warning - this method won't work in the case the id fields are
        // not set
        if (!(object instanceof DetailedConsentDirective)) {
            return false;
        }
        final DetailedConsentDirective other = (DetailedConsentDirective) object;
        if (((this.consentDirId == null) && (other.consentDirId != null))
            || ((this.consentDirId != null) && !this.consentDirId
            .equals(other.consentDirId))) {
            return false;
        }
        return true;
    }

    public Long getConsentDirId() {
        return this.consentDirId;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Date getOptinDate() {
        return this.optinDate;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (this.consentDirId != null ? this.consentDirId.hashCode() : 0);
        return hash;
    }

    public void setConsentDirId(final Long consentDirId) {
        this.consentDirId = consentDirId;
    }

    public void setExpirationDate(final Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setOptinDate(final Date optinDate) {
        this.optinDate = optinDate;
    }

    @Override
    public String toString() {
        return "gov.va.med.vler.nhin.vap.pip.entities.DetailedConsentDirective[consentDirId=" + this.consentDirId + "]";
    }

    public void setOptinConsentType(ConsentType optinConsentType) {
        this.optinConsentType = optinConsentType;
    }

    public ConsentType getOptinConsentType() {
        return optinConsentType;
    }

    public void setTotalRows(Long totalRows) {
        this.totalRows = totalRows;
    }

    public Long getTotalRows() {
        return totalRows;
    }

}
