package gov.va.nvap.svc.consentmgmt.stub.data;

import gov.va.nvap.common.validation.NullChecker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/**
 *
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "DELAYED_CONSENT_VIEW")
@NamedQueries({
    @NamedQuery(name = "DelayedConsentRpt.findAll", query = "SELECT d FROM DelayedConsentRpt d"),
    @NamedQuery(name = "DelayedConsentRpt.findByDelayedConsentId", query = "SELECT d FROM DelayedConsentRpt d WHERE d.delayedConsentId = :delayedConsentId"),
    @NamedQuery(name = "DelayedConsentRpt.findByPatientIen", query = "SELECT d FROM DelayedConsentRpt d WHERE d.patientIen = :patientIen"),
    @NamedQuery(name = "DelayedConsentRpt.findByPatientSsn", query = "SELECT d FROM DelayedConsentRpt d WHERE d.patientSsn = :patientSsn"),
    @NamedQuery(name = "DelayedConsentRpt.findByPatientLastName", query = "SELECT d FROM DelayedConsentRpt d WHERE d.patientLastName = :patientLastName"),
    @NamedQuery(name = "DelayedConsentRpt.findByPatientFirstName", query = "SELECT d FROM DelayedConsentRpt d WHERE d.patientFirstName = :patientFirstName"),
    @NamedQuery(name = "DelayedConsentRpt.findByPatientMiddleName", query = "SELECT d FROM DelayedConsentRpt d WHERE d.patientMiddleName = :patientMiddleName"),
    @NamedQuery(name = "DelayedConsentRpt.findByDateAdded", query = "SELECT d FROM DelayedConsentRpt d WHERE d.dateAdded = :dateAdded"),
    @NamedQuery(name = "DelayedConsentRpt.findByUserId", query = "SELECT d FROM DelayedConsentRpt d WHERE d.userId = :userId")})
public class DelayedConsentRpt implements Serializable {
    private static final long serialVersionUID = 1L;
    
    @Id
    @Basic(optional = false)
    @Column(name = "DELAYED_CONSENT_ID")
    private Long delayedConsentId;
    
    @Basic(optional = false)
    @Column(name = "PATIENT_IEN")
    private String patientIen;
    
    @Column(name = "PATIENT_SSN")
    private String patientSsn;
    
    @Basic(optional = false)
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    
    @Basic(optional = false)
    @Column(name = "PATIENT_FIRST_NAME")
    private String patientFirstName;
    
    @Column(name = "PATIENT_MIDDLE_NAME")
    private String patientMiddleName;
    
    @Basic(optional = false)
    @Column(name = "DATE_ADDED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateAdded;
    
    @Basic(optional = false)
    @Column(name = "USER_ID")
    private String userId;
    
    @JoinColumn(name = "CONSENT_TYPE_ID", referencedColumnName = "CONSENT_TYPE_ID")
    @ManyToOne(optional = false)
    private ConsentType consentTypeId;
    
    @Column(name = "PARENT_STATION_NUMBER")
    private String parentStationNumber;
    
    @Column(name = "STATION_NUMBER")
    private String stationNumber;
    
    @Basic(optional = false)
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    
    @Column (name = "STATUS")
    private String status;
    
    @Column (name = "RESOLUTION_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date resolutionDate;    
    
    @Column (name = "IS_TEST_PATIENT")
    private int isTestPatient;
    
    @Basic(optional = false)
    @Column(name = "PARENT_FACILITY_NAME")
    private String parentFacilityName;
    
    @Basic(optional = false)
    @Column(name = "VISN_NUMBER")
    private Long visnNumber;

    @JoinTable(name = "DELAYED_CONSENT_REASON", joinColumns = {
        @JoinColumn(name = "DELAYED_CONSENT_ID", referencedColumnName = "DELAYED_CONSENT_ID")}, inverseJoinColumns = {
        @JoinColumn(name = "DELAY_REASON_ID", referencedColumnName = "DELAY_REASON_ID")})
    @ManyToMany()
    @LazyCollection(LazyCollectionOption.FALSE)
    private Collection<DelayReason> delayReasonCollection;
    
    @OneToMany(mappedBy = "delayedConsentId")
    private Collection<MailNotification> mailNotificationCollection;
    
    @Transient 
    private Long total;
    
    @Transient 
    private String consentTypeName;
    
    public DelayedConsentRpt() {
    }

    public DelayedConsentRpt(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public DelayedConsentRpt(Long delayedConsentId, String patientIen, String patientLastName, String patientFirstName, Date dateAdded, String userId) {
        this.delayedConsentId = delayedConsentId;
        this.patientIen = patientIen;
        this.patientLastName = patientLastName;
        this.patientFirstName = patientFirstName;
        this.dateAdded = dateAdded;
        this.userId = userId;
    }

    public Long getDelayedConsentId() {
        return delayedConsentId;
    }

    public void setDelayedConsentId(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public String getPatientIen() {
        return patientIen;
    }

    public void setPatientIen(String patientIen) {
        this.patientIen = patientIen;
    }

    public String getPatientSsn() {
        return patientSsn;
    }

    public void setPatientSsn(String patientSsn) {
        this.patientSsn = patientSsn;
    }

    public String getPatientLastName() {
        return patientLastName;
    }

    public void setPatientLastName(String patientLastName) {
        this.patientLastName = patientLastName;
    }

    public String getPatientFirstName() {
        return patientFirstName;
    }

    public void setPatientFirstName(String patientFirstName) {
        this.patientFirstName = patientFirstName;
    }

    public String getPatientMiddleName() {
        return patientMiddleName;
    }

    public void setPatientMiddleName(String patientMiddleName) {
        this.patientMiddleName = patientMiddleName;
    }

    public Date getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ConsentType getConsentTypeId() {
        return consentTypeId;
    }

    public void setConsentTypeId(ConsentType consentTypeId) {
        this.consentTypeId = consentTypeId;
    }

    public String getParentStationNumber() {
        return parentStationNumber;
    }

    public void setParentStationNumber(String parentStationNumber) {
        this.parentStationNumber = parentStationNumber;
    }
    
    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }
    
    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public String getStatus() {
        return status;
    }
    
    public void setStatus(String status) {
        this.status = status;
    }
    
    public Date getResolutionDate() {
        return resolutionDate;
    }
    
    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }
    
    public Collection<DelayReason> getDelayReasonCollection() {
        if(NullChecker.isNullOrEmpty(delayReasonCollection))
        {
            return null;
        } else {
            return delayReasonCollection;
        }
    }

    public void setDelayReasonCollection(Collection<DelayReason> delayReasonCollection) {
        this.delayReasonCollection = delayReasonCollection;
    }

    public Collection<MailNotification> getMailNotificationCollection() {
        return mailNotificationCollection;
    }

    public void setMailNotificationCollection(Collection<MailNotification> mailNotificationCollection) {
        this.mailNotificationCollection = mailNotificationCollection;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (delayedConsentId != null ? delayedConsentId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof DelayedConsentRpt)) {
            return false;
        }
        DelayedConsentRpt other = (DelayedConsentRpt) object;
        if ((this.delayedConsentId == null && other.delayedConsentId != null) || (this.delayedConsentId != null && !this.delayedConsentId.equals(other.delayedConsentId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.DelayedConsentReport[ delayedConsentId=" + delayedConsentId + " ]";
    }
    
    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }
    
    public String getConsentTypeName() {
        return consentTypeName;
    }

    public void setConsentTypeName(String consentTypeName) {
        this.consentTypeName = consentTypeName;
    }
    
    public int getIsTestPatient() {
        return isTestPatient;
    }

    public void setIsTestPatient(int isTestPatient) {
        this.isTestPatient = isTestPatient;
    }
    
    public String getParentFacilityName() {
        return parentFacilityName;
    }
    
    public void setParentFacilityName(String parentFacilityName) {
        this.parentFacilityName = parentFacilityName;
    }
    
    public Long getVisnNumber() {
        return visnNumber;
    }
    
    public void setVisnNumber(Long visnNumber) {
        this.visnNumber = visnNumber;
    }
    
}
