package gov.va.nvap.svc.consentmgmt.stub.data;

import gov.va.nvap.common.validation.NullChecker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/**
 *
 * @since 04/06/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "DELAYED_CONSENT")
@NamedQueries({
    @NamedQuery(name = "DelayedConsent.findAll", query = "SELECT d FROM DelayedConsent d"),
    @NamedQuery(name = "DelayedConsent.findByDelayedConsentId", query = "SELECT d FROM DelayedConsent d WHERE d.delayedConsentId = :delayedConsentId"),
    @NamedQuery(name = "DelayedConsent.findByPatientIen", query = "SELECT d FROM DelayedConsent d WHERE d.patientIen = :patientIen"),
    @NamedQuery(name = "DelayedConsent.findByPatientSsn", query = "SELECT d FROM DelayedConsent d WHERE d.patientSsn = :patientSsn"),
    @NamedQuery(name = "DelayedConsent.findByPatientLastName", query = "SELECT d FROM DelayedConsent d WHERE d.patientLastName = :patientLastName"),
    @NamedQuery(name = "DelayedConsent.findByPatientFirstName", query = "SELECT d FROM DelayedConsent d WHERE d.patientFirstName = :patientFirstName"),
    @NamedQuery(name = "DelayedConsent.findByPatientMiddleName", query = "SELECT d FROM DelayedConsent d WHERE d.patientMiddleName = :patientMiddleName"),
    @NamedQuery(name = "DelayedConsent.findByDateAdded", query = "SELECT d FROM DelayedConsent d WHERE d.dateAdded = :dateAdded"),
    @NamedQuery(name = "DelayedConsent.findByUserId", query = "SELECT d FROM DelayedConsent d WHERE d.userId = :userId"),
    @NamedQuery(name = "DelayedConsent.findByConsentTypeAndStatus", query="SELECT d FROM DelayedConsent d WHERE d.patientIen = :patientIen AND d.status = :status AND d.consentTypeId.name = :consentType")})
public class DelayedConsent implements Serializable {

    private static final long serialVersionUID = 1L;
    
    @Id
    @Basic(optional = false)
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "DELAYED_CONSENT_ID")
    private Long delayedConsentId;
    @Basic(optional = false)
    @Column(name = "PATIENT_IEN")
    private String patientIen;
    @Column(name = "PATIENT_SSN")
    private String patientSsn;
    @Basic(optional = false)
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    @Basic(optional = false)
    @Column(name = "PATIENT_FIRST_NAME")
    private String patientFirstName;
    @Column(name = "PATIENT_MIDDLE_NAME")
    private String patientMiddleName;
    @Basic(optional = false)
    @Column(name = "DATE_ADDED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateAdded;
    @Basic(optional = false)
    @Column(name = "USER_ID")
    private String userId;
    @JoinColumn(name = "CONSENT_TYPE_ID", referencedColumnName = "CONSENT_TYPE_ID")
    @ManyToOne(optional = false)
    private ConsentType consentTypeId;
    @Column(name = "STATION_NUMBER")
    private String stationNumber;
    @Column (name = "STATUS")
    private String status;
    @Column (name = "RESOLUTION_DATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date resolutionDate;

    @JoinTable(name = "DELAYED_CONSENT_REASON", joinColumns = {
        @JoinColumn(name = "DELAYED_CONSENT_ID", referencedColumnName = "DELAYED_CONSENT_ID")}, inverseJoinColumns = {
        @JoinColumn(name = "DELAY_REASON_ID", referencedColumnName = "DELAY_REASON_ID")})
    @ManyToMany()
    @LazyCollection(LazyCollectionOption.FALSE)
    private Collection<DelayReason> delayReasonCollection;
    
    @OneToMany(mappedBy = "delayedConsentId")
    @LazyCollection(LazyCollectionOption.FALSE)
    private Collection<MailNotification> mailNotificationCollection;

    public DelayedConsent() {
    }

    public DelayedConsent(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public DelayedConsent(Long delayedConsentId, String patientIen, String patientLastName, String patientFirstName, Date dateAdded, String userId) {
        this.delayedConsentId = delayedConsentId;
        this.patientIen = patientIen;
        this.patientLastName = patientLastName;
        this.patientFirstName = patientFirstName;
        this.dateAdded = dateAdded;
        this.userId = userId;
    }

    public Long getDelayedConsentId() {
        return delayedConsentId;
    }

    public void setDelayedConsentId(Long delayedConsentId) {
        this.delayedConsentId = delayedConsentId;
    }

    public String getPatientIen() {
        return patientIen;
    }

    public void setPatientIen(String patientIen) {
        this.patientIen = patientIen;
    }

    public String getPatientSsn() {
        return patientSsn;
    }

    public void setPatientSsn(String patientSsn) {
        this.patientSsn = patientSsn;
    }

    public String getPatientLastName() {
        return patientLastName;
    }

    public void setPatientLastName(String patientLastName) {
        this.patientLastName = patientLastName;
    }

    public String getPatientFirstName() {
        return patientFirstName;
    }

    public void setPatientFirstName(String patientFirstName) {
        this.patientFirstName = patientFirstName;
    }

    public String getPatientMiddleName() {
        return patientMiddleName;
    }

    public void setPatientMiddleName(String patientMiddleName) {
        this.patientMiddleName = patientMiddleName;
    }

    public Date getDateAdded() {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ConsentType getConsentTypeId() {
        return consentTypeId;
    }

    public void setConsentTypeId(ConsentType consentTypeId) {
        this.consentTypeId = consentTypeId;
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }
    
    public String getStatus() {
        return status;
    }
    
    public void setStatus(String status) {
        this.status = status;
    }

    public Date getResolutionDate() {
        return resolutionDate;
    }
    
    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }
    
    public Collection<DelayReason> getDelayReasonCollection() {
        if(NullChecker.isNullOrEmpty(delayReasonCollection))
        {
            return null;
        } else {
            return delayReasonCollection;
        }
    }

    public void setDelayReasonCollection(Collection<DelayReason> delayReasonCollection) {
        this.delayReasonCollection = delayReasonCollection;
    }

    public Collection<MailNotification> getMailNotificationCollection() {
        return mailNotificationCollection;
    }

    public void setMailNotificationCollection(Collection<MailNotification> mailNotificationCollection) {
        this.mailNotificationCollection = mailNotificationCollection;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (delayedConsentId != null ? delayedConsentId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof DelayedConsent)) {
            return false;
        }
        DelayedConsent other = (DelayedConsent) object;
        if ((this.delayedConsentId == null && other.delayedConsentId != null) || (this.delayedConsentId != null && !this.delayedConsentId.equals(other.delayedConsentId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.DelayedConsent[ delayedConsentId=" + delayedConsentId + " ]";
    }
    
}
