package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/**
 *
 * @since 04/06/2016
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "DELAY_REASON")
@NamedQueries({
    @NamedQuery(name = "DelayReason.findAll", query = "SELECT d FROM DelayReason d"),
    @NamedQuery(name = "DelayReason.findByDelayReasonId", query = "SELECT d FROM DelayReason d WHERE d.delayReasonId = :delayReasonId"),
    @NamedQuery(name = "DelayReason.findByName", query = "SELECT d FROM DelayReason d WHERE d.name = :name")})
public class DelayReason implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "DELAY_REASON_ID")
    private Long delayReasonId;
    @Basic(optional = false)
    @Column(name = "NAME")
    private String name;
    @LazyCollection(LazyCollectionOption.FALSE)
    @ManyToMany(mappedBy = "delayReasonCollection")
    private Collection<DelayedConsent> delayedConsentCollection;

    public DelayReason() {
    }

    public DelayReason(Long delayReasonId) {
        this.delayReasonId = delayReasonId;
    }

    public DelayReason(Long delayReasonId, String name) {
        this.delayReasonId = delayReasonId;
        this.name = name;
    }

    public Long getDelayReasonId() {
        return delayReasonId;
    }

    public void setDelayReasonId(Long delayReasonId) {
        this.delayReasonId = delayReasonId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<DelayedConsent> getDelayedConsentCollection() {
        return delayedConsentCollection;
    }

    public void setDelayedConsentCollection(Collection<DelayedConsent> delayedConsentCollection) {
        this.delayedConsentCollection = delayedConsentCollection;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (delayReasonId != null ? delayReasonId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof DelayReason)) {
            return false;
        }
        DelayReason other = (DelayReason) object;
        if ((this.delayReasonId == null && other.delayReasonId != null) || (this.delayReasonId != null && !this.delayReasonId.equals(other.delayReasonId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "gov.va.nvap.svc.consentmgmt.stub.data.DelayReason[ delayReasonId=" + delayReasonId + " ]";
    }

}
