/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @author vhaislegberb
 */
@Entity
@Table(name = "CONSENT_TYPE")
@NamedQueries({
		@NamedQuery(name = "ConsentType.findAll", query = "SELECT c FROM ConsentType c"),
		@NamedQuery(name = "ConsentType.findByConsentTypeId", query = "SELECT c FROM ConsentType c WHERE c.consentTypeId = :consentTypeId"),
		@NamedQuery(name = "ConsentType.findByName", query = "SELECT c FROM ConsentType c WHERE c.name = :name") })
public class ConsentType implements Serializable {

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "consentTypeId")
    private Collection<DelayedConsent> delayedConsentCollection;
	private static final long serialVersionUID = 1L;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "CONSENT_TYPE_ID")
	private Long consentTypeId;
	@Basic(optional = false)
	@Column(name = "NAME")
	private String name;

	public ConsentType() {
	}

	public ConsentType(final Long consentTypeId) {
		this.consentTypeId = consentTypeId;
	}

	public ConsentType(final Long consentTypeId, final String name) {
		this.consentTypeId = consentTypeId;
		this.name = name;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof ConsentType)) {
			return false;
		}
		final ConsentType other = (ConsentType) object;
		if (((this.consentTypeId == null) && (other.consentTypeId != null))
				|| ((this.consentTypeId != null) && !this.consentTypeId
						.equals(other.consentTypeId))) {
			return false;
		}
		return true;
	}

	public Long getConsentTypeId() {
		return this.consentTypeId;
	}

	public String getName() {
		return this.name;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.consentTypeId != null ? this.consentTypeId.hashCode() : 0);
		return hash;
	}

	public void setConsentTypeId(final Long consentTypeId) {
		this.consentTypeId = consentTypeId;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return "gov.va.nvap.svc.consentmgmt.ConsentType[ consentTypeId="
				+ this.consentTypeId + " ]";
	}

    public Collection<DelayedConsent> getDelayedConsentCollection() {
        return delayedConsentCollection;
    }

    public void setDelayedConsentCollection(Collection<DelayedConsent> delayedConsentCollection) {
        this.delayedConsentCollection = delayedConsentCollection;
    }

}
