/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.annotations.Formula;

/**
 *
 * @author vhaislegberb
 */
@Entity
@Table(name = "PATIENT_CONSENT_DIR")
@NamedQueries({
		@NamedQuery(name = "ConsentDirective.findAll", query = "SELECT c FROM ConsentDirective c order by c.optinTS desc"),
		//@NamedQuery(name = "ConsentDirective.active.notExcluded.Reannounce", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.patientIen not in (SELECT DISTINCT d.patientIen FROM ConsentDirective d inner join d.excludedOrganizations eo where d.optinConsentType = :consentTypeRestrict and eo = :targetedOrganization and d.optoutTS is null) ORDER BY c.consentDirId"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.Reannounce", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null ORDER BY c.consentDirId"),             
        //@NamedQuery(name = "ConsentDirective.active.notExcluded", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdBeforeDate.Reannounce", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS < :beforeDate ORDER BY c.consentDirId"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdBeforeDate", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS < :beforeDate"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdAfterDate.Reannounce", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS > :afterDate ORDER BY c.consentDirId"),            
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdAfterDate", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS > :afterDate"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdBetweenDates.Reannounce", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS between :afterDate and :beforeDate ORDER BY c.consentDirId"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdBetweenDates", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS between :afterDate and :beforeDate"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.patientIen not in (SELECT DISTINCT d.patientIen FROM ConsentDirective d inner join d.excludedOrganizations eo where d.optinConsentType = :consentTypeRestrict and eo = :targetedOrganization and d.optoutTS is null) ORDER BY c.consentDirId"),             
        @NamedQuery(name = "ConsentDirective.active.notExcluded", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization = :targetedOrganization) ORDER BY c.consentDirId"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdBeforeDate", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS < :beforeDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization = :targetedOrganization) ORDER BY c.consentDirId"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdBeforeDate", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS < :beforeDate"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdAfterDate", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS > :afterDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization = :targetedOrganization) ORDER BY c.consentDirId"),            
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdAfterDate", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS > :afterDate"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.createdBetweenDates", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS between :afterDate and :beforeDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization = :targetedOrganization) ORDER BY c.consentDirId"),
        //@NamedQuery(name = "ConsentDirective.active.notExcluded.createdBetweenDates", query = "SELECT DISTINCT c FROM ConsentDirective c left outer join fetch c.excludedOrganizations eo where (eo is null or eo <> :targetedOrganization) and c.optoutTS is null and c.expirationDate > CURRENT_TIMESTAMP and c.optinTS between :afterDate and :beforeDate"), 
        
        @NamedQuery(name = "ConsentDirective.active.notExcluded.multOrgs", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization  in (:targetedOrganizations)) and c not in (SELECT a.consentDirective FROM AnnouncementOrg o JOIN o.announcement a where o.targetOrganization in (:targetedOrganizations)) ORDER BY c.consentDirId"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.multOrgs.createdBeforeDate", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS < :beforeDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization  in (:targetedOrganizations)) and c not in (SELECT a.consentDirective FROM AnnouncementOrg o JOIN o.announcement a where o.targetOrganization in (:targetedOrganizations)) ORDER BY c.consentDirId"),
        @NamedQuery(name = "ConsentDirective.active.notExcluded.multOrgs.createdAfterDate", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS > :afterDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization  in (:targetedOrganizations)) and c not in (SELECT a.consentDirective FROM AnnouncementOrg o JOIN o.announcement a where o.targetOrganization in (:targetedOrganizations)) ORDER BY c.consentDirId"), 
        @NamedQuery(name = "ConsentDirective.active.notExcluded.multOrgs.createdBetweenDates", query = "SELECT DISTINCT c FROM ConsentDirective c where c.optinConsentType = :consentTypeAuthorize and c.expirationDate > CURRENT_TIMESTAMP and c.optoutTS is null and c.optinTS between :afterDate and :beforeDate and c not in (SELECT a.consentDirective FROM Announcement a where a.targetOrganization in (:targetedOrganizations)) and c not in (SELECT a.consentDirective FROM AnnouncementOrg o JOIN o.announcement a where o.targetOrganization in (:targetedOrganizations)) ORDER BY c.consentDirId"),
              
        @NamedQuery(name = "ConsentDirective.findAllByPatient", query = "SELECT c FROM ConsentDirective c where c.patientIen IN (:patientIens) order by c.optinTS desc"),
		@NamedQuery(name = "ConsentDirective.findByConsentDirId", query = "SELECT c FROM ConsentDirective c WHERE c.consentDirId = :consentDirId"),
		@NamedQuery(name = "ConsentDirective.findByPatientIen", query = "SELECT c FROM ConsentDirective c WHERE c.patientIen IN (:patientIen)"),
		@NamedQuery(name = "ConsentDirective.findByOptinDate", query = "SELECT c FROM ConsentDirective c WHERE c.optinDate = :optinDate"),
		@NamedQuery(name = "ConsentDirective.findByOptoutDate", query = "SELECT c FROM ConsentDirective c WHERE c.optoutDate = :optoutDate"),
		@NamedQuery(name = "ConsentDirective.findByOptoutTS", query = "SELECT c FROM ConsentDirective c WHERE c.optoutTS = :optoutTS"),
		@NamedQuery(name = "ConsentDirective.findByExpirationDate", query = "SELECT c FROM ConsentDirective c WHERE c.expirationDate = :expirationDate"),
		@NamedQuery(name = "ConsentDirective.findByOptinTS", query = "SELECT c FROM ConsentDirective c WHERE c.optinTS = :optinTS"),
		@NamedQuery(name = "ConsentDirective.findActive", query = "SELECT c FROM ConsentDirective c WHERE c.patientIen IN (:patientIens) and c.optoutTS is null"),
		@NamedQuery(name = "ConsentDirective.findActiveByConsentType", query = "SELECT c FROM ConsentDirective c WHERE c.patientIen IN (:patientIens) and c.optinConsentType = :consentType and c.optoutConsentType is null") })

















		@NamedNativeQueries({
			@NamedNativeQuery(
					name="ConsentDirective.findAllExpiringConsentDirectives",
					query=ConsentDirective.findAllExpiringConsentDirectivesNativeSQL,
					resultClass=ConsentDirective.class
			),
            @NamedNativeQuery(
					name="ConsentDirective.findAllExpiringConsentDirectivesWithDates",
					query=ConsentDirective.findAllExpiringConsentDirectivesWithDatesNativeSQL,
					resultClass=ConsentDirective.class
			),
			@NamedNativeQuery(
					name="ConsentDirective.findAllFutureExpiringConsentDirectives",
					query=ConsentDirective.findAllFutureExpiringConsentDirectivesNativeSQL,
					resultClass=ConsentDirective.class
			),
                        @NamedNativeQuery(
					name="ConsentDirective.findAllFutureExpiringConsentDirectivesPage",
					query=ConsentDirective.findAllFutureExpiringConsentDirectivesPageNativeSQL,
					resultClass=ConsentDirective.class
			),
			@NamedNativeQuery(
					name="ConsentDirective.findExpiringConsentDirectives",
					query=ConsentDirective.findExpiringConsentDirectivesNativeSQL,
					resultClass=ConsentDirective.class
			),
			@NamedNativeQuery(
					name="ConsentDirective.findOptinConsentDirectives",
					query=ConsentDirective.findOptinConsentDirectivesNativeSQL,
					resultClass=ConsentDirective.class
			),
			@NamedNativeQuery(
					name="ConsentDirective.findOptoutConsentDirectives",
					query=ConsentDirective.findOptoutConsentDirectivesNativeSQL,
					resultClass=ConsentDirective.class
			),
            @NamedNativeQuery(
					name="ConsentDirective.findRecentlyExpiredConsent",
					query=ConsentDirective.findRecentlyExpiredConsentSQL,
					resultClass=ConsentDirective.class
			)
                        
		})

public class ConsentDirective implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * String constant native SQL for retrieving patient consent directives that are set to
	 * expire in a given number of days whose patients have NOT received a notification
	 */
	protected static final String findAllExpiringConsentDirectivesNativeSQL=
                "select * from(select a.*, row_number() over (ORDER BY a.consent_dir_id ASC) line_number, count(1) over () totalRows from patient_consent_dir a where  a.OPTIN_CONSENT_TYPE_ID IS NOT NULL and  a.optout_date is null and a.optout_ts is null and a.expiration_date < systimestamp + :days_until_expiration and a.expiration_date > systimestamp ) WHERE (line_number BETWEEN :from_page AND :to_page) OR (:to_page < 0) ORDER BY line_number";
    
    protected static final String findAllExpiringConsentDirectivesWithDatesNativeSQL=
                "select * from("+
		"select a.*, row_number() over (ORDER BY a.consent_dir_id ASC) line_number, count(1) over () totalRows " +

		"from patient_consent_dir a " +
		"where  a.OPTIN_CONSENT_TYPE_ID IS NOT NULL " +
		"and  a.optout_date is null and a.optout_ts is null " +
		"and    a.expiration_date <= to_date(:end_date, 'YYYY-MM-DD')" +
        "and    a.expiration_date > to_date(:start_date, 'YYYY-MM-DD')" +

		") WHERE (line_number BETWEEN :from_page AND :to_page) OR (:to_page < 0) ORDER BY line_number";
		
	/**
	 * String constant native SQL for retrieving patient consent directives that are set to
	 * expire at any future time whose patients have NOT received a notification
	 * 
	 * NOTE: Does not check if patients have already been notified
	 */
	protected static final String findAllFutureExpiringConsentDirectivesPageNativeSQL=
		"select * from("+
                "select a.*, row_number() over (ORDER BY a.consent_dir_id ASC) line_number, count(1) over () totalRows "+
		"from patient_consent_dir a " +
		"where  a.OPTIN_CONSENT_TYPE_ID IS NOT NULL " +
		"and  a.optout_date is null and a.optout_ts is null " +
        "and    a.expiration_date > systimestamp" +
        ") WHERE (line_number BETWEEN :from_page AND :to_page) OR (:to_page < 0) ORDER BY line_number";
        
        /**
	 * String constant native SQL for retrieving patient consent directives that are set to
	 * expire at any future time whose patients have NOT received a notification
	 * 
	 * NOTE: Does not check if patients have already been notified
	 */
	protected static final String findAllFutureExpiringConsentDirectivesNativeSQL=
		"Select a.*, count(1) over () totalRows " +
		"from patient_consent_dir a " +
		"where  a.OPTIN_CONSENT_TYPE_ID IS NOT NULL " +
		"and  a.optout_date is null and a.optout_ts is null " +

        "and    a.expiration_date > systimestamp";
        

	/**
	 * String constant native SQL for retrieving patient consent directives that are set to
	 * expire in a given number of days for the patient passed who have NOT received a notification
	 */
	protected static final String findExpiringConsentDirectivesNativeSQL=


		"select * from("+
		"select a.*, row_number() over (ORDER BY a.consent_dir_id ASC) line_number , count(1) over () totalRows " +
		"from patient_consent_dir a " +
		"where  a.optout_date is  null and a.optout_ts is null " +
		"and    a.expiration_date < systimestamp + :days_until_expiration " +
        "and    a.expiration_date > systimestamp " +
        "and    a.patient_ien in (:patient_iens) " +
		") WHERE (line_number BETWEEN :from_page AND :to_page) OR (:to_page < 0) ORDER BY line_number";

	/**
	 * String constant native SQL for retrieving patient consent directives that have expired
	 * for patients who have NOT received a notification
	 */
	protected static final String findExpiredConsentDirectivesNativeSQL=
		"select * from("+
		"select a.*, row_number() over (ORDER BY a.consent_dir_id ASC) line_number , count(1) over () totalRows " +
		"from patient_consent_dir a " +
		"where  a.optout_date is  null and a.optout_ts is null " +
		"and    a.expiration_date < systimestamp " +
		") WHERE (line_number BETWEEN :from_page AND :to_page) OR (:to_page < 0) ORDER BY line_number";

	/**
	 * String constant native SQL for retrieving patient opt-in consent directives that
	 * have been entered in a given number of days whose patients have NOT received a notification
	 */
	protected static final String findOptinConsentDirectivesNativeSQL=
		"select * from patient_consent_dir a " +
		"where  a.consent_type_id = :consent_type " +
		"and    a.optout_date is  null " +
		"and    a.optin_date > systimestamp - :optin_range_days ";

	/**
	 * String constant native SQL for retrieving patient opt-out consent directives that
	 * have been entered in a given number of days whose patients have NOT received a notification
	 */
	protected static final String findOptoutConsentDirectivesNativeSQL=
		"select * from patient_consent_dir a " +
		"where  a.consent_type_id = :consent_type " +
		"and    a.optout_date is not null " +
		"and    a.optout_date > systimestamp - :optout_range_days";
        
    /**
    * Retrieve recently expired patients that do not have a new opt-in entry for that consent type
    */
    protected static final String findRecentlyExpiredConsentSQL
        = "select  * from patient_consent_dir a where "
        + "a.EXPIRATION_DATE < trunc( sysdate) "
        // + "and  a.EXPIRATION_DATE >= trunc( sysdate -1 ) " //for only yesterday
        + "and OPTOUT_TS is null "
        + "and OPTOUT_DATE is null "
        + "and not exists "
        + "(select 1 from patient_consent_dir b where "
        + "a.PATIENT_IEN = b.PATIENT_IEN "
        + "and a.OPTIN_DATE < b.OPTIN_DATE "
        + "and a.OPTIN_CONSENT_TYPE_ID = b.OPTIN_CONSENT_TYPE_ID"
        + ")";

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "CONSENT_DIR_ID")
	private Long consentDirId;
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "OPTIN_CONSENT_TYPE_ID")
	private ConsentType optinConsentType;
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "OPTOUT_CONSENT_TYPE_ID")
	private ConsentType optoutConsentType;
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "POU_ID")
	private PurposeOfUse purposeOfUse;
	@Basic(optional = false)
	@Column(name = "OPTIN_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date optinTS;
	@ManyToMany(fetch = FetchType.EAGER)
	@JoinTable(name = "PATIENT_EXCLUDED_ORG", joinColumns = { @JoinColumn(name = "CONSENT_DIR_ID") }, inverseJoinColumns = { @JoinColumn(name = "ORG_ID") })
	private Collection<Organization> excludedOrganizations;
	@Column(name = "EXPIRATION_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date expirationDate;
	@Basic(optional = false)
	@Column(name = "OPTIN_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date optinDate;
	@Column(name = "OPTOUT_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date optoutTS;
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "OPTOUT_REASON_ID")
	private OptoutReason optoutReason;
	@Basic(optional = false)
	@Column(name = "PATIENT_IEN")
	private String patientIen;
	@Column(name = "OPTOUT_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date optoutDate;
	@Transient
	private Long totalRows;

	public ConsentDirective() {
	}

	public ConsentDirective(final Long consentDirId) {
		this.consentDirId = consentDirId;
	}

	public ConsentDirective(final Long consentDirId, final String patientIen,
			final Date optinDate, final Date expirationDate,
			final Date optinTS, final ConsentType consentType) {
		this.consentDirId = consentDirId;
		this.patientIen = patientIen;
		this.optinDate = optinDate;
		this.expirationDate = expirationDate;
		this.optinTS = optinTS;
		this.optinConsentType = consentType;
		}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof ConsentDirective)) {
			return false;
		}
		final ConsentDirective other = (ConsentDirective) object;
		if (((this.consentDirId == null) && (other.consentDirId != null))
				|| ((this.consentDirId != null) && !this.consentDirId
						.equals(other.consentDirId))) {
			return false;
		}
		return true;
	}

	public Long getConsentDirId() {
		return this.consentDirId;
	}

	public Date getOptinTS() {
		return this.optinTS;
	}

	public Collection<Organization> getExcludedOrganizations() {
		return this.excludedOrganizations;
	}

	public Date getExpirationDate() {
		return this.expirationDate;
	}

	public Date getOptinDate() {
		return this.optinDate;
	}
	public Date getOptoutDate() {
		return this.optoutDate;
	}
	public Date getOptoutTS() {
		return this.optoutTS;
	}

	public OptoutReason getOptoutReason() {
		return this.optoutReason;
	}

	public String getPatientIen() {
		return this.patientIen;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.consentDirId != null ? this.consentDirId.hashCode() : 0);
		return hash;
	}

	public void setConsentDirId(final Long consentDirId) {
		this.consentDirId = consentDirId;
	}

	public void setOptinTS(final Date optinTS) {
		this.optinTS = optinTS;
	}

	public void setExcludedOrganizations(
			final Collection<Organization> organizationsCollection) {
		this.excludedOrganizations = organizationsCollection;
	}

	public void setExpirationDate(final Date expirationDate) {
		this.expirationDate = expirationDate;
	}

	public void setOptinDate(final Date optinDate) {
		this.optinDate = optinDate;
	}
	public void setOptoutDate(final Date optoutDate) {
		this.optoutDate = optoutDate;
	}
	public void setOptoutTS(final Date optoutTS) {
		this.optoutTS = optoutTS;
	}

	public void setOptoutReason(final OptoutReason optoutReason) {
		this.optoutReason = optoutReason;
	}

	public void setPatientIen(final String patientIen) {
		this.patientIen = patientIen;
	}

	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.ConsentDirective[consentDirId="
				+ this.consentDirId + "]";
	}

	public void setOptoutConsentType(ConsentType optoutConsentType) {
		this.optoutConsentType = optoutConsentType;
	}

	public ConsentType getOptoutConsentType() {
		return optoutConsentType;
	}

	public void setOptinConsentType(ConsentType optinConsentType) {
		this.optinConsentType = optinConsentType;
	}

	public void setPurposeOfUse(PurposeOfUse purposeOfUse) {
		this.purposeOfUse = purposeOfUse;
	}

	public ConsentType getOptinConsentType() {
		return optinConsentType;
	}

	public PurposeOfUse getPurposeOfUse() {
		return purposeOfUse;
	}

	public Long getTotalRows() {
		return totalRows;
	}

	public void setTotalRows(Long totalRows) {
		this.totalRows = totalRows;
	}
	
}
