/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.data;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author vhaislegberb
 */
@Entity
@Table(name = "AUTHORITY")
@NamedQueries({
		@NamedQuery(name = "Authority.findAll", query = "SELECT a FROM Authority a"),
		@NamedQuery(name = "Authority.findByAuthorityId", query = "SELECT a FROM Authority a WHERE a.authorityId = :authorityId"),
		@NamedQuery(name = "Authority.findByOid", query = "SELECT a FROM Authority a WHERE a.oid = :oid"),
		@NamedQuery(name = "Authority.findByAuthorityName", query = "SELECT a FROM Authority a WHERE a.authorityName = :authorityName") })
public class Authority implements Serializable {
	private static final long serialVersionUID = 1L;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "AUTHORITY_ID")
	private Long authorityId;
	@Column(name = "AUTHORITY_NAME")
	private String authorityName;
	@Column(name = "OID")
	private String oid;

	public Authority() {
	}

	public Authority(final Long authorityId) {
		this.authorityId = authorityId;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof Authority)) {
			return false;
		}
		final Authority other = (Authority) object;
		if (((this.authorityId == null) && (other.authorityId != null))
				|| ((this.authorityId != null) && !this.authorityId
						.equals(other.authorityId))) {
			return false;
		}
		return true;
	}

	public Long getAuthorityId() {
		return this.authorityId;
	}

	public String getAuthorityName() {
		return this.authorityName;
	}

	public String getOid() {
		return this.oid;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.authorityId != null ? this.authorityId.hashCode() : 0);
		return hash;
	}

	public void setAuthorityId(final Long authorityId) {
		this.authorityId = authorityId;
	}

	public void setAuthorityName(final String authorityName) {
		this.authorityName = authorityName;
	}

	public void setOid(final String oid) {
		this.oid = oid;
	}

	@Override
	public String toString() {
		return "gov.va.nvap.svc.consentmgmt.entities.Authority[authorityId="
				+ this.authorityId + "]";
	}

}
