package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author Irakli Kakushadze
 * @since 05/28/2016
 */
public class PatientConsentDirDAO {

    @PersistenceContext
    private EntityManager em;

    // Public methods

    public SearchResponse find(final SearchRequest searchRequest) {
        final HashMap<String, Object> queryParams = new HashMap<String, Object>();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        String queryString = DetailedConsentDirective.constructQuery(searchRequest, queryParams);
        Query q = this.em.createNativeQuery(queryString, DetailedConsentDirective.class);
        SearchResponse searchResponse = new SearchResponse();

        if (searchRequest.startDate == null) {
            q.setParameter("start_date", null);
        } else {
            q.setParameter("start_date", dateFormat.format(searchRequest.startDate));
        }
        if (searchRequest.endDate == null) {
            q.setParameter("end_date", null);
        } else {
            q.setParameter("end_date", dateFormat.format(addTime(searchRequest.endDate, Calendar.HOUR, 24)));
        }

        if (searchRequest.consentTypeName.equals("NwHIN Authorization") || searchRequest.consentTypeName.isEmpty()) {
            q.setParameter("eheath_consent", "100");
        } else {
            q.setParameter("eheath_consent", "");
        }

        if (searchRequest.consentTypeName.equals("SSA Authorization") || searchRequest.consentTypeName.isEmpty()) {
            q.setParameter("ssa_consent", "102");
        } else {
            q.setParameter("ssa_consent", "");
        }

        if (searchRequest.userId.isEmpty()) {
            q.setParameter("user_id", null);
        } else {
            q.setParameter("user_id", searchRequest.userId);
        }

        q.setParameter("from_record", searchRequest.fromPage * searchRequest.recordsPerPage + 1);

        int toPage = searchRequest.recordsPerPage;
        if (searchRequest.fromPage > 0) {
            toPage = (searchRequest.fromPage + 1) * searchRequest.recordsPerPage;
        }
        q.setParameter("to_record", toPage);

        // Set query parameters
        DAOUtil.setQueryParams(q, queryParams);

        searchResponse.consents = q.getResultList();
        searchResponse.count = new Long(searchResponse.consents.size());
        
        return searchResponse;
    }

    /**
     * gets the count of all entries meeting the search requirement, not just the displayed page count
     * @param searchRequest
     * @return 
     */
    public SearchResponse findCount(final SearchRequest searchRequest) {
        final HashMap<String, Object> queryParams = new HashMap<String, Object>();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        String queryString = DetailedConsentDirective.constructCountQuery(searchRequest, queryParams);
        Query q = this.em.createNativeQuery(queryString);
        SearchResponse searchResponse = new SearchResponse();

        if (searchRequest.startDate == null) {
            q.setParameter("start_date", null);
        } else {
            q.setParameter("start_date", dateFormat.format(searchRequest.startDate));
        }
        if (searchRequest.endDate == null) {
            q.setParameter("end_date", null);
        } else {
            q.setParameter("end_date", dateFormat.format(addTime(searchRequest.endDate, Calendar.HOUR, 24)));
        }

        if (searchRequest.consentTypeName.equals("NwHIN Authorization") || searchRequest.consentTypeName.isEmpty()) {
            q.setParameter("eheath_consent", "100");
        } else {
            q.setParameter("eheath_consent", "");
        }

        if (searchRequest.consentTypeName.equals("SSA Authorization") || searchRequest.consentTypeName.isEmpty()) {
            q.setParameter("ssa_consent", "102");
        } else {
            q.setParameter("ssa_consent", "");
        }

        if (searchRequest.userId.isEmpty()) {
            q.setParameter("user_id", null);
        } else {
            q.setParameter("user_id", searchRequest.userId);
        }

        // Set query parameters
        DAOUtil.setQueryParams(q, queryParams);
        
        searchResponse.consents = null;
        //the count should be the only thing returned so its entry 0.
        Object count = q.getResultList().get(0);
        searchResponse.count = Long.parseLong(count.toString());
        
        return searchResponse;
    }
    
    public void setEntityManager(final EntityManager entityManager) {
        this.em = entityManager;
    }

    // Private methods
    
	public static Date addTime(final Date date, final int field, final int amount) {
		final Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(field, amount);
		final Date newDate = cal.getTime();
		return newDate;
	}
    
    // Inner classes

    public class SearchRequest {

        public String consentTypeName;
        public Date endDate;
        public int fromPage;
        public boolean includeUnknownVisn;
        public int patientTypes;
        public int recordsPerPage;
        public String sortBy;
        public String sortOrder;
        public Date startDate;
        public String stationNumbers;
        public String toPage;
        public String userId;

    }

    public class SearchResponse {

        public List<DetailedConsentDirective> consents = null;
        public long count = 0;

    }
}
