/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.stub.data.ConfidentialityCodeType;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientConfidentiality;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Required;

/**
 * The DAO class for the PATIENT_CONFIDENTIALITY table and PatientConfidentiality entity, 
 * to store and find the Confidentiality Code for each Patient ICN.
 * 
 * @author john
 */
public class PatientConfidentialityDAO {
    
    @PersistenceContext(name = "VapEntityManager")
    private EntityManager em;
    
    public void setEm(EntityManager entityManager) {
        this.em = entityManager;
    }
    
    private int restrictedMaxAgeInMinutes;    
    
    @Required
    public void setRestrictedMaxAgeInMinutes(int restrictedMaxAgeInMinutes) {
        this.restrictedMaxAgeInMinutes = restrictedMaxAgeInMinutes;
    }

    private int normalMaxAgeInMinutes;
        
    @Required
    public void setNormalMaxAgeInMinutes(int normalMaxAgeInMinutes) {
        this.normalMaxAgeInMinutes = normalMaxAgeInMinutes;
    }   
    
    public List<PatientConfidentiality> findAll() {
        try {
            final Query q = this.em.createNamedQuery("PatientConfidentiality.findAll");
            return (List<PatientConfidentiality>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<PatientConfidentiality>();
        }
    }

    public PatientConfidentiality findByPatientConfidentialityId(Long patientConfidentialityId) {
        try {
            final Query q = this.em.createNamedQuery("PatientConfidentiality.findByPatientConfidentialityId");
            q.setParameter("patientConfidentialityId", patientConfidentialityId);
            return (PatientConfidentiality) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }
    
    public PatientConfidentiality getConfidentialityCode(String patientIcn, int maxAgeInMinutes) {
        try {
            // calculate maxAgeInMinutesTS - new Date object = now - maxAgeInMinMinutes
            Date maxAgeInMinutesTS;
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.MINUTE, -maxAgeInMinutes);
            maxAgeInMinutesTS = cal.getTime();            
            final Query q = this.em.createNamedQuery("PatientConfidentiality.findByPatientIcnAndMaxAgeLimit");
            q.setParameter("patientIcn", patientIcn);
            q.setParameter("maxAgeInMinutesTS", maxAgeInMinutesTS);
            return (PatientConfidentiality) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }
    
    public PatientConfidentiality getConfidentialityCode(String patientIcn) {
        try {
            // calculate maxAgeInMinutesForNormalTS - new Date object = now - config. property normal.maxAgeInMinutes 
            //int normalMaxAgeInMinutes = 1440; // one day in minutes
            Date maxAgeInMinutesForNormalTS;
            Calendar calN = Calendar.getInstance();
            calN.add(Calendar.MINUTE, -this.normalMaxAgeInMinutes);
            maxAgeInMinutesForNormalTS = calN.getTime();             
            // calculate maxAgeInMinutesForRestrictedTS - new Date object = now - config. property restricted.maxAgeInMinutes
            //int restrictedMaxAgeInMinutes = 43200; // 30 days in minutes
            Date maxAgeInMinutesForRestrictedTS;
            Calendar calR = Calendar.getInstance();
            calR.add(Calendar.MINUTE, -this.restrictedMaxAgeInMinutes);
            maxAgeInMinutesForRestrictedTS = calR.getTime();
            // find a matching PatientConfidentiality entry        
            final Query q = this.em.createNamedQuery("PatientConfidentiality.findByPatientIcnAndMaxAgeLimitByConfidentialCode");
            q.setParameter("patientIcn", patientIcn);
            q.setParameter("maxAgeLimitForNormalTS", maxAgeInMinutesForNormalTS);
            q.setParameter("maxAgeLimitForRestrictedTS", maxAgeInMinutesForRestrictedTS);
            return (PatientConfidentiality) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    } 
    
    public PatientConfidentiality getConfidentialityCodeIgnoreMaxAge(String patientIcn) {
        try {
            final Query q = this.em.createNamedQuery("PatientConfidentiality.findByPatientIcn");
            q.setParameter("patientIcn", patientIcn);
            return (PatientConfidentiality) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    } 

    public int getRestrictedMaxAgeInMinutes() {
        return restrictedMaxAgeInMinutes;
    }

    public int getNormalMaxAgeInMinutes() {
        return normalMaxAgeInMinutes;
    }
    
    //@Transactional
    public PatientConfidentiality storeConfidentialityCode(String patientIcn, ConfidentialityCodeType confidentialityCode) throws Exception {
        PatientConfidentiality patientConfidentiality = null;
        try { 
            //boolean exists = false;  

            if (NullChecker.isNullOrEmpty(patientIcn)) {
                return null;
            }
            if (NullChecker.isNullOrEmpty(confidentialityCode)) {
                return null;
            }

            patientConfidentiality = new PatientConfidentiality();
            patientConfidentiality.setPatientIcn(patientIcn);
            patientConfidentiality.setConfidentialityCode(confidentialityCode);
            patientConfidentiality.setStoredTS(new Date());

            // see if one already exists for this patientIcn (which must be unique)
            PatientConfidentiality findResult = this.getConfidentialityCodeIgnoreMaxAge(patientIcn);
 
            // only add one if one does not already exist
            if (null == findResult) {
                em.persist(patientConfidentiality);
            } else {
                patientConfidentiality.setPatientConfidentialityId(findResult.getPatientConfidentialityId());
                patientConfidentiality = em.merge(patientConfidentiality);
            }            
        } catch (final Exception ex) {
           throw ex;
        }
        return patientConfidentiality;
    }
    
    //@Transactional    
    public PatientConfidentiality create(PatientConfidentiality patientConfidentiality) throws Exception {
        try {
            this.em.persist(patientConfidentiality);
        } catch (final Exception ex) {
            throw ex;
        }
        return patientConfidentiality;
    }
    
    //@Transactional
    public PatientConfidentiality update(PatientConfidentiality patientConfidentiality) throws Exception {
        try {
            this.em.merge(patientConfidentiality);
        } catch (final Exception ex) {
            throw ex;
        }
        return patientConfidentiality;
    }
    
    //@Transactional
    public boolean existByPatientIcn(String patientIcn) {
        PatientConfidentiality result = this.getConfidentialityCodeIgnoreMaxAge(patientIcn);
        if(null == result) {
            return false;
        } else {
            return true;
        }
    }
    
    public void setEntityManager(final EntityManager entityManager) {
        this.em = entityManager;
    }
    
}
