package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.MailTemplate;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @since 06/02/2016
 * @author Johann Sonnenberg
 */
public class MailTemplateDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Transactional
    public MailTemplate getByLetterType(Long letterTypeId) {
        try {
            final Query q = this.em.createQuery("SELECT fl FROM MailTemplate fl WHERE fl.letterTypeId = :letterTypeId");
            q.setParameter("letterTypeId", letterTypeId);
            return (MailTemplate) q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }
}
