package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.MailLog;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Johann Sonnenberg
 */
public class MailLogDAO {
    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }
    
    @Transactional
    public Long create(MailLog m) throws Exception {
        try {
            this.em.persist(m);
        } catch (final Exception ex) {
            throw ex;
        }
        
        return m.getMailLogId();
    }
    
    @Transactional
    public List<MailLog> findByConsentDirId(String consentDirId) {
        try {
            final Query q = this.em.createQuery("SELECT m FROM MailLog m WHERE m.consentDirId = :consentDirId ORDER BY m.mailLogId DESC");
            q.setParameter("consentDirId", Long.parseLong(consentDirId));
            
            return (List<MailLog>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<MailLog>();
        }
    }
    
    @Transactional
    public List<MailLog> findByDelayedConsentId(String delayedConsentId) {
        try {
            final Query q = this.em.createQuery("SELECT m FROM MailLog m WHERE m.delayedConsentId = :delayedConsentId ORDER BY m.mailLogId DESC");
            q.setParameter("delayedConsentId", Long.parseLong(delayedConsentId));
            
            return (List<MailLog>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<MailLog>();
        }
    }
}
