package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.LetterType;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @since 06/02/2016
 * @author Johann Sonnenberg
 */
public class LetterTypeDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Transactional
    public List<LetterType> listAll() {
        try {
            final Query q = this.em.createQuery("SELECT t FROM LetterType t ORDER BY t.name DESC");

            return (List<LetterType>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<LetterType>();
        }
    }
}
