/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.Descriptor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Johann Sonnenberg
 */
public class DescriptorDAO {
    
    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }
    
    @Transactional
    public List<Descriptor> getDescriptorsByName(String names) {
        try {
            final Query q = this.em.createQuery("SELECT d FROM Descriptor d WHERE d.name IN (:names)");
            q.setParameter("names", names);
            
            return (List<Descriptor>) q.getResultList();
        } catch (final Exception e) {
            return new ArrayList<Descriptor>();
        }
    }
    
    @Transactional
    public List<Descriptor> getAll() {
        try {
            final Query q = this.em.createQuery("SELECT d FROM Descriptor d");
            
            return (List<Descriptor>) q.getResultList();
        } catch (final Exception e) {
            return new ArrayList<Descriptor>();
        }
    }
}
