package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.DelayedConsent;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @since 04/05/2016
 * @author Johann Sonnenberg
 */
public class DelayedConsentDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Transactional
    public Long create(DelayedConsent da) throws Exception {
        try {
            da.setStatus("PENDING");
            this.em.persist(da);
        } catch (final Exception ex) {
            throw ex;
        }

        return da.getDelayedConsentId();
    }

    @Transactional
    public DelayedConsent update(DelayedConsent da) throws Exception {
        try {
            this.em.merge(da);
        } catch (final Exception ex) {
            throw ex;
        }

        return da;
    }
    
    public SearchAllResponse find(final SearchAllRequest searchRequest) {
        SearchAllResponse searchResponse = new SearchAllResponse();

        final Query q = this.em.createNamedQuery("DelayedConsent.findAll");
        searchResponse.delayedConsents = (List<DelayedConsent>) q.getResultList();
        searchResponse.count = searchResponse.delayedConsents.size();
            
        return searchResponse;
    }
    
    public DelayedConsent findByDelayedConsentId(Long delayedConsentId) {
        try {
            final Query q = this.em.createNamedQuery("DelayedConsent.findByDelayedConsentId");
            q.setParameter("delayedConsentId", delayedConsentId);
            
            return (DelayedConsent)q.getSingleResult();
        } catch (final NoResultException nre) {
            return new DelayedConsent();
        }
    }

    public List<DelayedConsent> findByPatientIen(String patientIen) {
        try {
            final Query q = this.em.createNamedQuery("DelayedConsent.findByPatientIen");
            q.setParameter("patientIen", patientIen);

            return (List<DelayedConsent>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<DelayedConsent>();
        }
    }

    public DelayedConsent findByTypeAndStatus(String consentType, String status, String patientIen) {
        try {
            final Query q = this.em.createNamedQuery("DelayedConsent.findByConsentTypeAndStatus");
            q.setParameter("status", status);
            q.setParameter("consentType", consentType);
            q.setParameter("patientIen", patientIen);
            
            return (DelayedConsent)q.getSingleResult();
        } catch (final NoResultException nre) {
            return null;
        }
    }
    
    public class SearchAllRequest {

        public String patientSsn;
        public String patientLastName;
        public String patientFirstName;
        public String reasonsForDelay;
        public String daysSinceDelayed;
        public String daysSinceLastNotification;
        public String consentType;
        public String authenticatingFacility;
        public String enteredBy;
        public String patientTypes;
        public String length;
        public String start;
        public String sortBy;
        public String sortOrder;
    }

    public class SearchAllResponse {

        public List<DelayedConsent> delayedConsents = null;
        public long count = 0;
    }
}
