package gov.va.nvap.svc.consentmgmt.stub.dao;

import gov.va.nvap.svc.consentmgmt.stub.data.DelayReason;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @since 04/05/2016
 * @author Johann Sonnenberg
 */
public class DelayReasonDAO {

    @PersistenceContext
    private EntityManager em;

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<DelayReason> findAll() {
        try {
            final Query q = this.em.createNamedQuery("DelayReason.findAll");
            return (List<DelayReason>) q.getResultList();
        } catch (final NoResultException nre) {
            return new ArrayList<DelayReason>();
        }
    }

    public DelayReason findByDelayReasonId(Long delayReasonId) {
        try {
            final Query q = this.em.createNamedQuery("DelayReason.findByDelayReasonId");
            q.setParameter("delayReasonId", delayReasonId);
            return (DelayReason) q.getSingleResult();
        } catch (final NoResultException nre) {
            return new DelayReason();
        }
    }

    public DelayReason findByName(String name) {
        try {
            final Query q = this.em.createNamedQuery("DelayReason.findByName");
            q.setParameter("name", name);
            return (DelayReason) q.getSingleResult();
        } catch (final NoResultException nre) {
            return new DelayReason();
        }
    }

}
