package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientRequest;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.jaxb.AnnouncePatientResponse;
import java.util.List;

/**
 * Announce patients asynchronously or synchronously.
 * 
 * @author Asha Amritraj
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
public interface PatientAnnouncer {

	/**
	 * Announce the patient to the NwHIN. This is a direct synchronous call that
	 * calls the NwHIN webservice.
	 * 
	 * @param announcePatientRequest
	 * @return
	 * @throws PatientAnnouncerException
	 */
	public AnnouncePatientResponse announce(
			AnnouncePatientRequest announcePatientRequest)
			throws PatientAnnouncerException;

	/**
	 * Asynchronously announce the patient over the NwHIN. It puts the announce
	 * message on a queue and processes them by calling the synchronous
	 * announce() call above. This does not write to the ANNOUNCEMENTS table.
	 * 
	 * @param announcePatientRequest
	 * @throws PatientAnnouncerException
	 */
	public void announceAsync(AnnouncePatientRequest announcePatientRequest)
			throws PatientAnnouncerException;

    public AnnouncePatientResponse announceAll(
            AnnouncePatientRequest announcePatientRequest)
            throws PatientAnnouncerException;

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    public List<Announcement> getAnnouncementsByUserId(String userId);
    
    /**
     * Finds all announcements for a list of consent directive ID numbers.
     * 
     * @param consentDirectiveIds List of Consent Directive ID numbers
     * @return List of objects of type Announcement found for this consent directive
     */
    public List<Announcement> getAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds);
}