/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.NotificationType;
import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author vhaispbowmag
 */
@Entity
@Table(name = "NOTIFICATION")
@NamedQueries({
		@NamedQuery(name = "Notification.findAll",
				query = "SELECT a FROM Notification a")
})
public class Notification implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "NOTIFICATION_ID")
	private Long notificationId;

/*	@Lob
	@Column(name = "ANNOUNCEMENT_RESULT")
	private String announcementResult;

	@Column(name = "BATCH_ID")
	private String batchId;
*/

	@Column(name = "COMPLETED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date completedTs;

	@JoinColumn(name = "CONSENT_DIR_ID", referencedColumnName = "CONSENT_DIR_ID")
	@ManyToOne(optional = false)
	private ConsentDirective consentDirective;

	@Column(name = "CREATED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdTs;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "NOTIFICATION_TYPE_ID")
	private NotificationType notificationType;

/*	@Column(name = "SCHEDULED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date scheduledTs;

	@JoinColumn(name = "ORGANIZATION_ID", referencedColumnName = "ORG_ID")
	@ManyToOne(optional = false)
	private Organization targetOrganization;
*/
	@Column(name = "USER_ID")
	private String userId;

	public Notification() {
	}

/*	public Notification(final Long announcementId) {
		this.announcementId = announcementId;
	}
*/
	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof Notification)) {
			return false;
		}
		final Notification other = (Notification) object;
		if (((this.notificationId == null) && (other.notificationId != null))
				|| ((this.notificationId != null) && !this.notificationId
						.equals(other.notificationId))) {
			return false;
		}
		return true;
	}

	public Long getNotificationId() {
		return notificationId;
	}

	public void setNotificationId(Long notificationId) {
		this.notificationId = notificationId;
	}

	public Date getCompletedTs() {
		return completedTs;
	}

	public void setCompletedTs(Date completedTs) {
		this.completedTs = completedTs;
	}

	public ConsentDirective getConsentDirective() {
		return consentDirective;
	}

	public void setConsentDirective(ConsentDirective consentDirective) {
		this.consentDirective = consentDirective;
	}

	public Date getCreatedTs() {
		return createdTs;
	}

	public void setCreatedTs(Date createdTs) {
		this.createdTs = createdTs;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Override
	public String toString() {
		return "gov.va.nvap.svc.consentmgmt.entities.Notification[notificationId="
				+ this.notificationId + "]";
	}

}
