/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

import gov.va.nvap.svc.consentmgmt.stub.data.Organization;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/**
 *
 * @author vhaislegberb
 * @author Irakli Kakushadze
 */
public interface AnnouncerInterface {

	/**
	 * Creates an announcement batch given the parameters received.
	 *
	 * @param targetedOrganization
	 *            The organization to target; if null, throws
	 *            IllegalArgumentException
	 * @param dateRangeStart
	 *            The start of the date range used to constrain the set of
	 *            consent directives to build the announcement batch from. May
	 *            be null
	 * @param dateRangeStop
	 *            The end of the date range used to constrain the set of consent
	 *            directives to build the announcement batch from. May be null.
	 * @param reannounce
	 *            Flag which indicates whether a re-announce of a previously
	 *            announced consent directive should be performed.
	 * @return The batch identifier for the new batch of announcements.
	 * @throws AnnounceException
	 *             if the creation of the batch fails.
	 */
	String createAnnouncementsBatch(Organization targetedOrganization,
			String userId, Date dateRangeStart, Date dateRangeStop,
			boolean reannounce);

    String createAnnouncementsBatch(Organization targetedOrganization,
			String userId, HashSet<String> iens);
    
    /**
	 * Creates an announcement batch given the parameters received.
	 *
	 * @param targetedOrganizations
	 *            Collection of target organizations for batch announcement
	 * @param dateRangeStart
	 *            The start of the date range used to constrain the set of
	 *            consent directives to build the announcement batch from. May
	 *            be null
	 * @param dateRangeStop
	 *            The end of the date range used to constrain the set of consent
	 *            directives to build the announcement batch from. May be null.
	 * @param reannounce
	 *            Flag which indicates whether a re-announce of a previously
	 *            announced consent directive should be performed.
	 * @return The batch identifier for the new batch of announcements.
	 * @throws AnnounceException
	 *             if the creation of the batch fails.
	 */
	String createAnnouncementsBatch(Collection<Organization> targetedOrganizations,
			String userId, Date dateRangeStart, Date dateRangeStop,
			boolean reannounce);

    String createAnnouncementsBatch(Collection<Organization> targetedOrganizations,
			String userId, HashSet<String> iens);
    
	/**
	 * Gets the announcement using it's unique identifier.
	 *
	 * @param announcementId
	 *            The unique identifier of the announcement.
	 * @return The announcement.
	 */
	Announcement getAnnouncementById(Long announcementId);

    /**
     * Finds all announcements for a particular user.
     * 
     * @param userId User ID
     * @return List of objects of type Announcement found for this user
     */
    List<Announcement> getAnnouncementsByUserId(String userId);
    
    /**
     * Finds all announcements for a list of consent directive ID numbers.
     * 
     * @param consentDirectiveIds List of Consent Directive ID numbers
     * @return List of objects of type Announcement found for this consent directive
     */  
    List<Announcement> getAnnouncementsByConsentDirectiveId(List<Long> consentDirectiveIds);
    
	/**
	 * Retrieves summary information for the announcement batches specified in
	 * by the method parameter.
	 *
	 * @param batchIds
	 *            The list of batch identifiers to retrieve summaries for.
	 * @return The list of batch summaries.
	 */
	List<AnnouncementBatchSummary> getBatchSummary(List<String> batchIds);

	/**
	 * Retrieves summary information for the announcement batches specified in
	 * by the method parameter.
	 *
	 * @param batchIds
	 *            The list of batch identifiers to retrieve summaries for.
	 * @return The list of batch summaries.
	 */
	List<AnnouncementBatchSummary> getBatchSummaryByDateRange(Date startDate,
			Date endDate);

	/**
	 * Gets a collection of announcements that are part of the identified batch.
	 * The assumption here is that if the collection returned is less than
	 * maxAnnouncements, there are no additional announcements that are part of
	 * this batch.
	 *
	 * @param batchId
	 *            The batch identifier for the batch of announcements being
	 *            requested.
	 * @param maxAnnouncements
	 *            The max number of announcements to be returned by any one
	 *            invocation of the method.
	 * @return The collection of announcement; shall not be null.
	 */
	Collection<Announcement> getUnscheduledAnnouncementsByBatchId(
			String batchId, int maxAnnouncements, int firstResult);

	/**
	 * Deletes the list of batches that correspond to the batch identifiers
	 * presented in the batchIds parameter.
	 *
	 * @param batchIds
	 *            The list of batches that need to be deleted.
	 * @throws AnnounceException
	 *             in the event that the delete of the announcement fails.
	 */
	void removeAnnouncementBatches(Collection<String> batchIds);

	/**
	 * Get the list of announcement batch summaries by date range, organization.
	 *
	 * @param startDate
	 *            the start date (optional)
	 * @param endDate
	 *            the end date (optional)
	 * @param orgOid
	 *            the organization OID (optional)
	 * @param userId
	 *            the organization OID (optional)
	 * @param firstResult
	 *            the index to start the first record (optional)
	 * @param the
	 *            maximum number of results (optional)
	 * @return list of batch summaries
	 */
	List<AnnouncementBatchSummary> retrieveBatchSummaries(Date startDate,
			Date endDate, String orgOid, String userId, int firstResult,
			int maxResults);

	/**
	 * Store an announcement record.
	 *
	 * @param announcement
	 *            the announcement object
	 */
	void storeAnnouncement(Announcement announcement);
    
    public void createAnnouncementOrg(AnnouncementOrg announceOrg);
    
    List<Announcement> getNonBatchAnnouncementsByCreatedTs(Date createdTs, String patientIen);
    
    int getAnnounceExclusionTimeframeHours();
    
    List<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(Announcement announcement);
    
    void removeByAnnouncement(Announcement announcement);
    
    public HashMap getAnnouncementsByBatchIdWithPaging(String batchId, String orgId, Integer startRow, Integer maxRows);
}
