package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 *
 * @author Johann Sonnenberg
 */
@Entity
@Table(name = "ANNOUNCEMENT_PATIENT")
public class AnnouncementPatient {
    private Announcement announcement;
    private Long announcementId;
    
    @GenericGenerator(name = "generator", strategy = "foreign", parameters = @Parameter(name = "property", value="annoucement"))
    @Id
    @GeneratedValue(generator = "generator")
    @Column(name = "ANNOUNCEMENT_ID")
    public Long getAnnouncementId() {
        return announcementId;
    }
    
    public void setAnnouncementId(Long announcementId) {
        this.announcementId = announcementId;
    }
    
    @OneToOne(fetch = FetchType.LAZY)
    @PrimaryKeyJoinColumn
    public Announcement getAnnouncement() {
        return this.announcement;
    }
	
    @Column(name = "FIRST_NAME")
	private String firstName;
    
    @Column(name = "LAST_NAME")
	private String lastName;
    
    @Column(name = "SSN")
	private String ssn;
    
    @Column(name = "PATIENT_IEN")
	private String patientIen;

    public AnnouncementPatient() {
        
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getPatientIen() {
        return patientIen;
    }

    public void setPatientIen(String patientIen) {
        this.patientIen = patientIen;
    }
    
    
}
