package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * 
 * @author Zack Peterson
 */
@Entity
@Table(name = "ANNOUNCEMENT_ORGS")
@NamedQueries({
		@NamedQuery(name = "AnnouncementOrg.findAll", query = "SELECT o FROM AnnouncementOrg o"),
		@NamedQuery(name = "AnnouncementOrg.findByAnnouncementOrgId", query = "SELECT o FROM AnnouncementOrg o WHERE o.announcementOrgId = :announcementOrgId"),
		@NamedQuery(name = "AnnouncementOrg.findByTargetOrganization", query = "SELECT o FROM AnnouncementOrg o WHERE o.targetOrganization = :targetOrganization"),
		@NamedQuery(name = "AnnouncementOrg.findByAnnouncement", query = "SELECT o FROM AnnouncementOrg o WHERE o.announcement = :announcement"),
        @NamedQuery(name = "Announcement.deleteByAnnouncement", query = "DELETE FROM AnnouncementOrg o WHERE o.announcement = :announcement"),
		@NamedQuery(name = "AnnouncementOrg.findByResult", query = "SELECT o FROM AnnouncementOrg o WHERE o.announceResult = :announceResult"),
        @NamedQuery(name = "AnnouncementOrg.batchSummary", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(o.orgName, COUNT(n.announcementId), MIN(n.createdTs)) "
				+ "FROM AnnouncementOrg a JOIN a.targetOrganization o JOIN a.announcement n "
				+ "WHERE n.batchId IN (:batchIds) " + "GROUP BY o.orgName") })
public class AnnouncementOrg implements Serializable {
	private static final long serialVersionUID = 1L;
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "ANNOUNCEMENT_ORG_ID")
	private Long announcementOrgId;
    @JoinColumn(name = "ORG_ID", referencedColumnName = "ORG_ID")
	@ManyToOne(optional = true)
	private Organization targetOrganization;
    @JoinColumn(name = "ANNOUNCEMENT_ID", referencedColumnName = "ANNOUNCEMENT_ID")
	@ManyToOne(optional = false) //Maybe false
	private Announcement announcement;
//    @Basic(optional = true)
//	@Column(name = "ANNOUNCEMENT_ID")
//	private Long announcementId;
	@Basic(optional = true)
	@Column(name = "ANNOUNCE_RESULT")
	private String announceResult;

	public AnnouncementOrg() {
	}

	public AnnouncementOrg(final Long announcementOrgId) {
		this.announcementOrgId = announcementOrgId;
	}

	public AnnouncementOrg(final Long announcementOrgId, final Organization targetOrganization, 
            final Announcement announcement, final String result) {
		this.announcementOrgId = announcementOrgId;
		this.targetOrganization = targetOrganization;
		this.announcement = announcement;
        this.announceResult = result;
	}
    
//    public AnnouncementOrg(final Long announcementOrgId, final Organization targetOrganization, 
//            final Long announcementId, final String result) {
//		this.announcementOrgId = announcementOrgId;
//		this.targetOrganization = targetOrganization;
//		this.announcementId = announcementId;
//        this.announceResult = result;
//	}

    public Long getAnnouncementOrgId() {
        return announcementOrgId;
    }

    public void setAnnouncementOrgId(Long announcementOrgId) {
        this.announcementOrgId = announcementOrgId;
    }

    public Organization getTargetOrganization() {
        return targetOrganization;
    }

    public void setTargetOrganization(Organization targetOrganization) {
        this.targetOrganization = targetOrganization;
    }

    public Announcement getAnnouncement() {
        return announcement;
    }

    public void setAnnouncement(Announcement announcement) {
        this.announcement = announcement;
    }

//    public Long getAnnouncementId() {
//        return announcementId;
//    }
//
//    public void setAnnouncementId(Long announcementId) {
//        this.announcementId = announcementId;
//    }

    public String getAnnounceResult() {
        return announceResult;
    }

    public void setAnnounceResult(String result) {
        this.announceResult = result;
    }

	@Override
	public String toString() {
		return "gov.va.med.vler.nhin.vap.pip.entities.AnnouncementOrgs[announcementOrgId="
				+ this.announcementOrgId + "]";
	}

}
