/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data;

//import gov.va.nvap.svc.consentmgmt.jpa.AnnouncementOrgJpaController;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author vhaislegberb
 * @author Irakli Kakushadze
 * @author Zack Peterson
 */
@Entity
@Table(name = "ANNOUNCEMENT")
@NamedQueries({
		@NamedQuery(name = "Announcement.findAll", query = "SELECT a FROM Announcement a"),
		@NamedQuery(name = "Announcement.findByConsentDirectiveAndTargetOrg", query = "SELECT a FROM Announcement a where a.consentDirective = :consentDirective and a.targetOrganization = :organization"),
        @NamedQuery(name = "Announcement.findByConsentDirectiveId", query = "SELECT a FROM Announcement a where a.consentDirective.consentDirId = :consentDirective"),
        @NamedQuery(name = "Announcement.findByConsentDirectiveIdList", query = "SELECT a FROM Announcement a where a.consentDirective.consentDirId IN (:consentDirectiveIdList) ORDER BY a.completedTs ASC"),
		@NamedQuery(name = "Announcement.findByAnnouncementId", query = "SELECT a FROM Announcement a WHERE a.announcementId = :announcementId"),
		@NamedQuery(name = "Announcement.findByScheduledTs", query = "SELECT a FROM Announcement a WHERE a.scheduledTs = :scheduledTs"),
		@NamedQuery(name = "Announcement.findByCompletedTs", query = "SELECT a FROM Announcement a WHERE a.completedTs = :completedTs"),
		@NamedQuery(name = "Announcement.findByBatchId", query = "SELECT a FROM Announcement a WHERE a.batchId = :batchId ORDER by a.announcementId"),
        @NamedQuery(name = "Announcement.findByBatchIdCount", query = "SELECT COUNT(a.announcementId) FROM Announcement a WHERE a.batchId = :batchId"),
        @NamedQuery(name = "Announcement.findByUserId", query = "SELECT a FROM Announcement a WHERE a.userId = :userId ORDER by a.announcementId"),
		@NamedQuery(name = "Announcement.deleteByBatchIds", query = "DELETE FROM Announcement a WHERE a.batchId in (:batchIds)"),
        //@NamedQuery(name = "Announcement.findByBatchIdAndOrgId", query = "SELECT a, o FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o WHERE a.batchId = :batchId AND o.orgId = :orgId"),
        //@NamedQuery(name = "Announcement.findCountByBatchIdAndOrgId", query = "SELECT COUNT(a.announcementId) FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o WHERE a.batchId = :batchId AND o.orgId = :orgId"),
        @NamedQuery(name = "Announcement.findByBatchIdAndOrgId", query="SELECT a FROM Announcement a WHERE a.batchId = :batchId AND (a.targetOrganization.orgId = :orgId OR a.targetOrganization.orgId IS NULL)"),
        @NamedQuery(name = "Announcement.findCountByBatchIdAndOrgId", query="SELECT COUNT(a.announcementId) FROM Announcement a WHERE a.batchId = :batchId AND (a.targetOrganization.orgId = :orgId OR a.targetOrganization.orgId IS NULL)"),
		@NamedQuery(name = "Announcement.batchSummary", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(o.orgName, COUNT(a.announcementId), MIN(a.createdTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId IN (:batchIds) " + "GROUP BY o.orgName"),
		@NamedQuery(name = "Announcement.allBatchSummary", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId"),
		@NamedQuery(name = "Announcement.batchSummaryByDate", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate"),
		@NamedQuery(name = "Announcement.batchSummaryFromDate", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate"),
		@NamedQuery(name = "Announcement.batchSummaryToDate", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate"),
		// #133
		@NamedQuery(name = "Announcement.allBatchSummaryByOrganization", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryByDateAndOrganization", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndOrganization", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryToDateAndOrganization", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		@NamedQuery(name = "Announcement.allBatchSummaryByUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId"),
		@NamedQuery(name = "Announcement.batchSummaryByDateAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate"),
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate"),
		@NamedQuery(name = "Announcement.batchSummaryToDateAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate"),
		// #133
		@NamedQuery(name = "Announcement.allBatchSummaryByOrganizationAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryByDateAndOrganizationAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndOrganizationAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryToDateAndOrganizationAndUserId", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM Announcement a JOIN a.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
        @NamedQuery(name = "Announcement.batchSummary2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(o.orgName, COUNT(a.announcementId), MIN(a.createdTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId IN (:batchIds) " + "GROUP BY o.orgName"),
		@NamedQuery(name = "Announcement.allBatchSummary2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId"),
		@NamedQuery(name = "Announcement.batchSummaryByDate2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate"),
		@NamedQuery(name = "Announcement.batchSummaryFromDate2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate"),
		@NamedQuery(name = "Announcement.batchSummaryToDate2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate"),
		// #133
		@NamedQuery(name = "Announcement.allBatchSummaryByOrganization2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryByDateAndOrganization2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndOrganization2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryToDateAndOrganization2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		@NamedQuery(name = "Announcement.allBatchSummaryByUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId"),
		@NamedQuery(name = "Announcement.batchSummaryByDateAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate"),
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate"),
		@NamedQuery(name = "Announcement.batchSummaryToDateAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate"),
		// #133
		@NamedQuery(name = "Announcement.allBatchSummaryByOrganizationAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId, o.orgName, o.orgId "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryByDateAndOrganizationAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) between :startDate and :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryFromDateAndOrganizationAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) >= :startDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		// #133
		@NamedQuery(name = "Announcement.batchSummaryToDateAndOrganizationAndUserId2", query = "SELECT NEW gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary(a.batchId, o.orgName, o.orgId, COUNT(a.announcementId), MIN(a.createdTs), COUNT(a.scheduledTs), COUNT(a.completedTs)) "
				+ "FROM AnnouncementOrg j JOIN j.announcement a JOIN j.targetOrganization o "
				+ "WHERE a.batchId is not null AND o.orgOid=:orgOid AND a.userId=:userId "
				+ "GROUP BY a.batchId,o.orgName, o.orgId "
				+ "HAVING MIN(a.createdTs) <= :endDate "
				+ "ORDER BY MIN(a.createdTs) DESC"),
		@NamedQuery(name = "Announcement.findNonBatchAnnouncementsByCreatedTs", 
                query = "SELECT a FROM Announcement a JOIN a.consentDirective c " +
                        "WHERE a.createdTs >= :createdTs AND a.batchId is null AND c.patientIen = :patientIen " +
                        "ORDER BY a.createdTs DESC")

})
public class Announcement implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Basic(optional = false)
	@Column(name = "ANNOUNCEMENT_ID")
	private Long announcementId;

	@Lob
	@Column(name = "ANNOUNCEMENT_RESULT")
	private String announcementResult;

	@Column(name = "BATCH_ID")
	private String batchId;

	@Column(name = "COMPLETED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date completedTs;

	@JoinColumn(name = "CONSENT_DIR_ID", referencedColumnName = "CONSENT_DIR_ID", nullable = true)
	@ManyToOne(optional = true)
	private ConsentDirective consentDirective;
	
	@Column(name = "CREATED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdTs;

	@Column(name = "SCHEDULED_TS")
	@Temporal(TemporalType.TIMESTAMP)
	private Date scheduledTs;

	//@JoinColumn(name = "ORGANIZATION_ID", referencedColumnName = "ORG_ID", nullable = true)
    @JoinColumn(name = "ORGANIZATION_ID", referencedColumnName = "ORG_ID")
	@ManyToOne(optional = true)
	private Organization targetOrganization;

    @Column(name = "PATIENT_IEN")
    private String PatientIen;
    
	@Column(name = "USER_ID")
	private String userId;

	@Column(name = "HIE_TRANSACTION_ID")
	private String hieTransactionId;
    
    @Column(name = "FIRST_NAME")
    private String firstName;
    
    @Column(name = "LAST_NAME")
    private String lastName;
    
    @Column(name = "SSN")
    private String ssn;
    
//    @OneToMany
//    @JoinTable(name="ANNOUNCEMENT_ORGS", inverseJoinColumns=@JoinColumn(name="ANNOUNCEMENT_ID"))
//    private Collection<AnnouncementOrg> announcementOrgs;
    
//    @OneToMany
//    @JoinColumn(table="ANNOUNCEMENT_ORGS", name="ANNOUNCEMENT_ID", referencedColumnName="ANNOUNCEMENT_ID")
//    private Collection<AnnouncementOrg> announcementOrgs;
    
    //private Collection<AnnouncementOrg> announcementOrgs;

	public Announcement() {
	}

	public Announcement(final Long announcementId) {
		this.announcementId = announcementId;
	}

	@Override
	public boolean equals(final Object object) {
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if (!(object instanceof Announcement)) {
			return false;
		}
		final Announcement other = (Announcement) object;
		if (((this.announcementId == null) && (other.announcementId != null))
				|| ((this.announcementId != null) && !this.announcementId
						.equals(other.announcementId))) {
			return false;
		}
		return true;
	}

	public Long getAnnouncementId() {
		return this.announcementId;
	}

	public String getAnnouncementResult() {
		return this.announcementResult;
	}

	public String getBatchId() {
		return this.batchId;
	}

	public Date getCompletedTs() {
		return this.completedTs;
	}

	public Date getCreatedTs() {
		return this.createdTs;
	}

	public ConsentDirective getPatientConsentDir() {
		return this.consentDirective;
	}

    public String getPatientIen() {
        return this.PatientIen;
    }
    
	public Date getScheduledTs() {
		return this.scheduledTs;
	}

	public Organization getTargetOrganization() {
		return this.targetOrganization;
	}

	public String getUserId() {
		return this.userId;
	}

	public String getHieTransactionId() {
		return this.hieTransactionId;
	}

	@Override
	public int hashCode() {
		int hash = 0;
		hash += (this.announcementId != null ? this.announcementId.hashCode()
				: 0);
		return hash;
	}

	public void setAnnouncementId(final Long announcementId) {
		this.announcementId = announcementId;
	}

	public void setAnnouncementResult(final String announcementResult) {
		this.announcementResult = announcementResult;
	}

	public void setBatchId(final String batchId) {
		this.batchId = batchId;
	}

	public void setCompletedTs(final Date completedTs) {
		this.completedTs = completedTs;
	}

	public void setCreatedTs(final Date createdTs) {
		this.createdTs = createdTs;
	}

	public void setPatientConsentDir(final ConsentDirective patientConsentDir) {
		this.consentDirective = patientConsentDir;
	}

    public void setPatientIen(final String patientIen) {
        this.PatientIen = patientIen;
    }
    
	public void setScheduledTs(final Date scheduledTs) {
		this.scheduledTs = scheduledTs;
	}

	public void setTargetOrganization(final Organization targetOrganization) {
		this.targetOrganization = targetOrganization;
	}

	public void setUserId(final String userId) {
		this.userId = userId;
	}

	public void setHieTransactionId(final String hieTransactionId) {
		this.hieTransactionId = hieTransactionId;
	}

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }
    
    

//    public Collection<AnnouncementOrg> getAnnouncementOrgs() {
//        if (announcementOrgs == null) {
//            AnnouncementOrgJpaController announceController = new AnnouncementOrgJpaController();
//            
//            
//            // NOT FINISHED /////////////////////////////
//            
//            
//            announcementOrgs = announceController.findAllAnnouncementOrgs();
//        }
//        return announcementOrgs;
//    }
//
//    public void setAnnouncementOrgs(Collection<AnnouncementOrg> announcementOrgs) {
//        this.announcementOrgs = announcementOrgs;
//    }

	@Override
	public String toString() {
		return "gov.va.nvap.svc.consentmgmt.entities.Announcement[announcementId="
				+ this.announcementId + "]";
	}

}
