package gov.va.nvap.svc.consentmgmt.schedule;

import gov.va.nvap.svc.consentmgmt.stub.data.Schedule;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Elan
 * @since 07/05/2016
 */
public class ScheduleDAO {

    /**
     * Entity Manager instance.
     */
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public Boolean create(final String type) {
        try {
            Schedule s = new Schedule();
            s.setEventDate(new Date());
            s.setType(type);
            this.em.persist(s);
        } catch (final Exception ex) {
            return false;
        }
        return true;
    }

    public Boolean checkDaily(String type) {
        final Query query = this.em.createNamedQuery("Schedule.checkToday").setParameter("type", type);
        try {
            query.getSingleResult();
            return true;
        } catch (NoResultException e) {
            return false;
        }
    }

    /**
     * Set the entity manager (Injected by Spring).
     */
    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
}
