/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.PurposeOfUseControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 */
public class PurposeOfUseJpaController implements
		PurposeOfUseControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final PurposeOfUse purposeOfUse)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(purposeOfUse);
		} catch (final Exception ex) {
			if (this.findPurposeOfUse(purposeOfUse.getPouId()) != null) {
				throw new PreexistingEntityException("PurposeOfUse "
						+ purposeOfUse + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws NonexistentEntityException {
		PurposeOfUse purposeOfUse;
		try {
			purposeOfUse = this.entityManager.getReference(PurposeOfUse.class,
					id);
			purposeOfUse.getPouId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The purposeOfUse with id "
					+ id + " no longer exists.", enfe);
		}
		this.entityManager.remove(purposeOfUse);
	}

	@Override
	public void edit(PurposeOfUse purposeOfUse)
			throws NonexistentEntityException, Exception {
		try {
			purposeOfUse = this.entityManager.merge(purposeOfUse);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = purposeOfUse.getPouId();
				if (this.findPurposeOfUse(id) == null) {
					throw new NonexistentEntityException(
							"The purposeOfUse with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public PurposeOfUse findPurposeOfUse(final Long id) {
		return this.entityManager.find(PurposeOfUse.class, id);
	}

	@Override
	public List<PurposeOfUse> findPurposeOfUseEntities() {
		return this.findPurposeOfUseEntities(true, -1, -1);
	}

	private List<PurposeOfUse> findPurposeOfUseEntities(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("PurposeOfUse.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	public List<PurposeOfUse> findPurposeOfUseEntities(final int maxResults,
			final int firstResult) {
		return this.findPurposeOfUseEntities(false, maxResults, firstResult);
	}

	public int getPurposeOfUseCount() {
		final Query q = this.entityManager
				.createQuery("select count(pou) from PurposeOfUse");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

}
