/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.PatientDocumentTypeControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.IllegalOrphanException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 */
public class PatientDocumentTypeJpaController implements
		PatientDocumentTypeControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final PatientDocumentType patientDocumentType)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(patientDocumentType);
		} catch (final Exception ex) {
			if (this.findPatientDocumentType(patientDocumentType
					.getDocumentTypeId()) != null) {
				throw new PreexistingEntityException("PatientDocumentType "
						+ patientDocumentType + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws IllegalOrphanException,
			NonexistentEntityException {
		PatientDocumentType patientDocumentType;
		try {
			patientDocumentType = this.entityManager.getReference(
					PatientDocumentType.class, id);
			patientDocumentType.getDocumentTypeId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException(
					"The patientDocumentType with id " + id
							+ " no longer exists.", enfe);
		}
		this.entityManager.remove(patientDocumentType);
	}

	@Override
	public void edit(PatientDocumentType patientDocumentType)
			throws IllegalOrphanException, NonexistentEntityException,
			Exception {
		try {
			this.entityManager.find(PatientDocumentType.class,
					patientDocumentType.getDocumentTypeId());
			patientDocumentType = this.entityManager.merge(patientDocumentType);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = patientDocumentType.getDocumentTypeId();
				if (this.findPatientDocumentType(id) == null) {
					throw new NonexistentEntityException(
							"The patientDocumentType with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public PatientDocumentType findPatientDocumentType(final Long id) {
		return this.entityManager.find(PatientDocumentType.class, id);
	}

	@Override
	public PatientDocumentType findPatientDocumentTypeByName(
			final String documentName) {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocumentType.findByDocumentName");
		q.setParameter("documentName", documentName);
		return (PatientDocumentType) q.getSingleResult();
	}

	private List<PatientDocumentType> findPatientDocumentTypeEntities(
			final boolean all, final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocumentType.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	@Override
	public List<PatientDocumentType> findPatientDocumentTypeEntities(
			final EntityManager em) {
		return this.findPatientDocumentTypeEntities(true, -1, -1);
	}

	public List<PatientDocumentType> findPatientDocumentTypeEntities(
			final int maxResults, final int firstResult) {
		return this.findPatientDocumentTypeEntities(false, maxResults,
				firstResult);
	}

	public int getPatientDocumentTypeCount() {
		final Query q = this.entityManager
				.createQuery("select count(pdt) from PatientDocumentType");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

}
