/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.PatientDocumentControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocument;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;

import java.util.Collection;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 * @author Zack Peterson
 */
public class PatientDocumentJpaController implements
		PatientDocumentControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final PatientDocument patientDocument)
			throws PreexistingEntityException, Exception {
		try {
			PatientDocumentType patientDocumentType = patientDocument
					.getPatientDocumentType();
			if (patientDocumentType != null) {
				patientDocumentType = this.entityManager.getReference(
						patientDocumentType.getClass(),
						patientDocumentType.getDocumentTypeId());
				patientDocument.setPatientDocumentType(patientDocumentType);
			} else {
                patientDocument.setPatientDocumentType(new PatientDocumentType(2L, "OPT-OUT"));
            }
			this.entityManager.persist(patientDocument);
		} catch (final Exception ex) {
			if (this.findPatientDocument(patientDocument.getDocumentId()) != null) {
				throw new PreexistingEntityException("PatientDocument "
						+ patientDocument + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws NonexistentEntityException {
		PatientDocument patientDocument;
		try {
			patientDocument = this.entityManager.getReference(
					PatientDocument.class, id);
			patientDocument.getDocumentId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The patientDocument with id "
					+ id + " no longer exists.", enfe);
		}
		this.entityManager.remove(patientDocument);
	}

	@Override
	public void edit(PatientDocument patientDocument)
			throws NonexistentEntityException, Exception {
		try {
			final PatientDocument persistentPatientDocument = this.entityManager
					.find(PatientDocument.class,
							patientDocument.getDocumentId());
			persistentPatientDocument.getPatientDocumentType();
			PatientDocumentType patientDocumentTypeNew = patientDocument
					.getPatientDocumentType();
			if (patientDocumentTypeNew != null) {
				patientDocumentTypeNew = this.entityManager.getReference(
						patientDocumentTypeNew.getClass(),
						patientDocumentTypeNew.getDocumentTypeId());
				patientDocument.setPatientDocumentType(patientDocumentTypeNew);
			}
			patientDocument = this.entityManager.merge(patientDocument);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = patientDocument.getDocumentId();
				if (this.findPatientDocument(id) == null) {
					throw new NonexistentEntityException(
							"The patientDocument with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public Collection<PatientDocument> findByConsentDirective(
			final ConsentDirective consentDirective) {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocument.findByConsentDir");
		q.setParameter("consentDirective", consentDirective);
		return q.getResultList();
	}

	@Override
	public PatientDocument findByConsentDirectiveAndType(
			final ConsentDirective consentDirective,
			final PatientDocumentType patientDocumentType) {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocument.findByConsentDirAndType");
		q.setParameter("consentDirective", consentDirective);
		q.setParameter("patientDocumentType", patientDocumentType);
		final List<PatientDocument> patientDocuments = q.getResultList();
		if ((null == patientDocuments)
				|| ((null != patientDocuments) && (patientDocuments.size() <= 0))) {
			return null;
		} else {
			return patientDocuments.get(0);
		}
	}

	@Override
	public PatientDocument findPatientDocument(final Long id) {
		return this.entityManager.find(PatientDocument.class, id);
	}

	private List<PatientDocument> findPatientDocumentEntities(
			final boolean all, final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocument.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	public List<PatientDocument> findPatientDocumentEntities(
			final EntityManager em) {
		return this.findPatientDocumentEntities(true, -1, -1);
	}

	public List<PatientDocument> findPatientDocumentEntities(
			final int maxResults, final int firstResult) {
		return this.findPatientDocumentEntities(false, maxResults, firstResult);
	}

	@Override
	public Collection<PatientDocumentType> findPatientDocumentTypes() {
		final Query q = this.entityManager
				.createNamedQuery("PatientDocumentType.findAll");
		return q.getResultList();
	}

	public int getPatientDocumentCount(final EntityManager em) {
		final Query q = em
				.createQuery("select count(pd.*) from PatientDocument pd");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}
}
