/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.OrganizationsControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 */
public class OrganizationsJpaController implements
		OrganizationsControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final Organization organizations)
			throws PreexistingEntityException, Exception {

		try {
			this.entityManager.persist(organizations);
		} catch (final Exception ex) {
			if (this.findOrganization(organizations.getOrgId()) != null) {
				throw new PreexistingEntityException("Organizations "
						+ organizations + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws NonexistentEntityException {
		Organization organizations;
		try {
			organizations = this.entityManager.getReference(Organization.class,
					id);
			organizations.getOrgId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The organizations with id "
					+ id + " no longer exists.", enfe);
		}
		this.entityManager.remove(organizations);
	}

	@Override
	public void edit(Organization organizations)
			throws NonexistentEntityException, Exception {
		try {
			organizations = this.entityManager.merge(organizations);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = organizations.getOrgId();
				if (this.findOrganization(id) == null) {
					throw new NonexistentEntityException(
							"The organizations with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public Organization findOrganization(final Long id) {
		return this.entityManager.find(Organization.class, id);
	}

	@Override
	public Organization findOrganizationByName(final String orgName) {
		final Query q = this.entityManager
				.createNamedQuery("Organization.findByOrgName");
		q.setParameter("orgName", orgName);
		return (Organization) q.getSingleResult();
	}

	@Override
	public Organization findOrganizationByOid(final String oid) {
		try {
			final Query q = this.entityManager
					.createNamedQuery("Organization.findByOrgOid");
			q.setParameter("orgOid", oid);
			return (Organization) q.getSingleResult();
		} catch (final NoResultException nre) {
			// this is OK.
			return null;
		}
	}

	private List<Organization> findOrganizationsEntities(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("Organization.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	@Override
	public List<Organization> findOrganizationsEntities(final EntityManager em) {
		return this.findOrganizationsEntities(true, -1, -1);
	}

	public List<Organization> findOrganizationsEntities(final int maxResults,
			final int firstResult) {
		return this.findOrganizationsEntities(false, maxResults, firstResult);
	}

	@Override
	public List<Organization> getActiveOrganizations() {
		final Query q = this.entityManager
				.createNamedQuery("Organization.findByActive");
		q.setParameter("active", 'Y');
		return q.getResultList();
	}

	public int getOrganizationsCount(final EntityManager em) {
		final Query q = em.createQuery("select count(o.*) from Organization o");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

	@Override
	public Collection<Organization> getActiveNonConsumerOnlyOrganizations() {
		final Query q = this.entityManager
				.createNamedQuery("Organization.findByActiveOrgConsumerOnly");
		q.setParameter("active", 'Y');
		q.setParameter("orgConsumerOnly", 'N');
		return q.getResultList();
	}

	@Override
	public Collection<Organization> getActiveConsumerOnlyOrganizations() {
		final Query q = this.entityManager
				.createNamedQuery("Organization.findByActiveOrgConsumerOnly");
		q.setParameter("active", 'Y');
		q.setParameter("orgConsumerOnly", 'Y');
		return q.getResultList();
	}
    
    @Override
    public Boolean getIsOrganizationTrustedSource(String organizationId) {
        final Query q = this.entityManager.createNamedQuery("Organization.getIsTrustedClinicalSource");
        q.setParameter("organizationId", organizationId);
        
        List results = q.getResultList();
        
        if(results.isEmpty()) {
            return false; //we didn't find the partner organization so return false
        } else {
            Character isTrustedSource = (Character)results.get(0);
        
            return "Y".equals(Character.toString(isTrustedSource));
        }
    }
}