/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.FunctionalRoleControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.FunctionalRole;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 */
public class FunctionalRoleJpaController implements
		FunctionalRoleControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final FunctionalRole functionalRole)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(functionalRole);
		} catch (final Exception ex) {
			if (this.findFunctionalRole(functionalRole.getFunctionalRoleId()) != null) {
				throw new PreexistingEntityException("FunctionalRole "
						+ functionalRole + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws NonexistentEntityException {
		FunctionalRole functionalRole;
		try {
			functionalRole = this.entityManager.getReference(
					FunctionalRole.class, id);
			functionalRole.getFunctionalRoleId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The functionalRole with id "
					+ id + " no longer exists.", enfe);
		}
		this.entityManager.remove(functionalRole);
	}

	@Override
	public void edit(FunctionalRole functionalRole)
			throws NonexistentEntityException, Exception {
		try {
			functionalRole = this.entityManager.merge(functionalRole);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = functionalRole.getFunctionalRoleId();
				if (this.findFunctionalRole(id) == null) {
					throw new NonexistentEntityException(
							"The functionalRole with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public FunctionalRole findFunctionalRole(final Long id) {
		return this.entityManager.find(FunctionalRole.class, id);
	}

	@Override
	public List<FunctionalRole> findFunctionalRoleEntities() {
		return this.findFunctionalRoleEntities(true, -1, -1);
	}

	private List<FunctionalRole> findFunctionalRoleEntities(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("FunctionalRole.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	@Override
	public List<FunctionalRole> findFunctionalRoleEntities(
			final int maxResults, final int firstResult) {
		return this.findFunctionalRoleEntities(false, maxResults, firstResult);
	}

	public int getFunctionalRoleCount() {
		final Query q = this.entityManager
				.createQuery("SELECT COUNT(fr.*) FROM FunctionalRole fr");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

}
