/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.FacilityControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author vhaislegberb
 */
public class FacilityJpaController implements FacilityControllerInterface {

    @PersistenceContext(name = "VapEntityManager")
    private EntityManager em;

    @Override
    public void create(final Facility facility)
        throws PreexistingEntityException, Exception {
        try {
            this.em.persist(facility);
        } catch (final Exception ex) {
            if (this.findFacility(facility.getFacilityId()) != null) {
                throw new PreexistingEntityException("Facility " + facility
                    + " already exists.", ex);
            }
            throw ex;
        }
    }

    public void destroy(final Long id) throws NonexistentEntityException {
        this.em.getTransaction().begin();
        Facility facility;
        try {
            facility = this.em.getReference(Facility.class, id);
            facility.getFacilityId();
        } catch (final EntityNotFoundException enfe) {
            throw new NonexistentEntityException("The facility with id " + id
                + " no longer exists.", enfe);
        }
        this.em.remove(facility);
        this.em.getTransaction().commit();
    }

    @Override
    public void edit(Facility facility) throws NonexistentEntityException,
        Exception {
        try {
            facility = this.em.merge(facility);
        } catch (final Exception ex) {
            final String msg = ex.getLocalizedMessage();
            if ((msg == null) || (msg.length() == 0)) {
                final Long id = facility.getFacilityId();
                if (this.findFacility(id) == null) {
                    throw new NonexistentEntityException(
                        "The facility with id " + id + " no longer exists.");
                }
            }
            throw ex;
        }
    }

    @Override
    public Collection<Facility> findAllowedFacilities() {
        final Query q = this.em.createNamedQuery("Facility.findByAllowed");
        q.setParameter("allowed", true);
        return q.getResultList();
    }

    @Override
    public Facility findFacility(final Long id) {
        return this.em.find(Facility.class, id);
    }

    @Override
    public Facility findFacilityByStation(final String stationId) {
        final Query q = this.em.createNamedQuery("Facility.findByFacilityStation");
        q.setParameter("facilityStation", stationId);
        Facility fac = new Facility((gov.va.nvap.svc.facility.data.Facility) q.getSingleResult());
        return fac;
    }

    @Override
    public String findFacilityStationByName(final String facilityName) {
        final Query q = this.em
            .createNamedQuery("Facility.findByFacilityName");
        q.setParameter("facilityName", facilityName);
        try {
            return ((String) q.getSingleResult());
        } catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Facility> findFacilityEntities() {
        return this.findFacilityEntities(true, -1, -1);
    }

    private List<Facility> findFacilityEntities(final boolean all,
        final int maxResults, final int firstResult) {
        final Query q = this.em
            .createQuery("select object(o) from Facility as o");
        if (!all) {
            q.setMaxResults(maxResults);
            q.setFirstResult(firstResult);
        }
        return q.getResultList();
    }

    @Override
    public List<Facility> findFacilityEntities(final int maxResults,
        final int firstResult) {
        return this.findFacilityEntities(false, maxResults, firstResult);
    }

    @Override
    public Facility findFacilityByName(final String facilityName) {
        //final Query q = this.em.createNamedQuery("Facility.findFullByFacilityName");
        final Query q = this.em.createQuery("SELECT f FROM Facility f WHERE lower(f.facilityName) = lower(:facilityName)");
        q.setParameter("facilityName", facilityName);
        try {
            return (Facility) q.getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    public int getFacilityCount() {
        final Query q = this.em
            .createQuery("select count(o) from Facility as o");
        return ((Long) q.getSingleResult()).intValue();
    }

    public void setEntityManager(final EntityManager em) {
        this.em = em;
    }
}
