package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.ExpiringConsentControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.ExpiringConsentConfiguration;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class ExpiringConsentConfigurationJpaController implements
		ExpiringConsentControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;
	
	@Override
	public void edit(ExpiringConsentConfiguration config) throws NonexistentEntityException,
			Exception {
		try {
			this.entityManager.merge(config);
		} catch (final Exception ex) {
			System.out.println("Broken!");
		}
	}

	@Override
	public ExpiringConsentConfiguration getConfiguration() {
		try {
			final Query q = this.entityManager
					.createNamedQuery("ExpiringConsentConfiguration.findAll");
			return (ExpiringConsentConfiguration) q.getSingleResult();
		} catch (final NoResultException nre) {
			return null;
		}
	}

}