/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.common.validation.NullChecker;
import gov.va.nvap.svc.consentmgmt.ConsentDirectiveControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.IllegalOrphanException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.dao.DAOUtil;
import gov.va.nvap.svc.consentmgmt.stub.dao.PatientConsentDirDAO;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.FacilityOptInConsent;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.transaction.annotation.Transactional;

public class ConsentDirectiveJpaController implements
		ConsentDirectiveControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final ConsentDirective consentDirective)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(consentDirective);
		} catch (final Exception ex) {
			if ((consentDirective.getConsentDirId() != null)
					&& (this.findConsentDirective(consentDirective
							.getConsentDirId()) != null)) {
				throw new PreexistingEntityException("ConsentDirective "
						+ consentDirective + " already exists.", ex);
			}
			throw ex;
		}
	}

	public void destroy(final Long id) throws IllegalOrphanException,
			NonexistentEntityException {
		ConsentDirective consentDirective;
		try {
			consentDirective = this.entityManager.getReference(
					ConsentDirective.class, id);
			consentDirective.getConsentDirId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException(
					"The consentDirective with id " + id + " no longer exists.",
					enfe);
		}

		this.entityManager.remove(consentDirective);
	}

	@Override
	public void edit(ConsentDirective consentDirective)
			throws IllegalOrphanException, NonexistentEntityException,
			Exception {
		try {
			final ConsentDirective persistentConsentDirective = this.entityManager
					.find(ConsentDirective.class,
							consentDirective.getConsentDirId());
			persistentConsentDirective.getExcludedOrganizations();
			Collection<Organization> organizationsCollectionNew = consentDirective
					.getExcludedOrganizations();
			final Collection<Organization> attachedOrganizationsCollectionNew = new ArrayList<Organization>();
			for (Organization organizationsCollectionNewOrganizationsToAttach : organizationsCollectionNew) {
				organizationsCollectionNewOrganizationsToAttach = this.entityManager
						.getReference(
								organizationsCollectionNewOrganizationsToAttach
										.getClass(),
								organizationsCollectionNewOrganizationsToAttach
										.getOrgId());
				attachedOrganizationsCollectionNew
						.add(organizationsCollectionNewOrganizationsToAttach);
			}
			organizationsCollectionNew = attachedOrganizationsCollectionNew;
			consentDirective
					.setExcludedOrganizations(organizationsCollectionNew);

			consentDirective = this.entityManager.merge(consentDirective);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = consentDirective.getConsentDirId();
				if (this.findConsentDirective(id) == null) {
					throw new NonexistentEntityException(
							"The consentDirective with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public ConsentDirective findConsentDirective(final Long id) {
		return this.entityManager.find(ConsentDirective.class, id);
	}

	private List<ConsentDirective> findConsentDirectiveEntities(
			final boolean all, final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("ConsentDirective.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	public List<ConsentDirective> findConsentDirectiveEntities(
			final EntityManager em) {
		return this.findConsentDirectiveEntities(true, -1, -1);
	}

	public List<ConsentDirective> findConsentDirectiveEntities(
			final int maxResults, final int firstResult) {
		return this
				.findConsentDirectiveEntities(false, maxResults, firstResult);
	}

	@Override
	public ConsentType findConsentTypeByName(final String name) {
		try {
			final Query q = this.entityManager
					.createNamedQuery("ConsentType.findByName");
			q.setParameter("name", name);
			return (ConsentType) q.getSingleResult();
		} catch (final NoResultException nre) {
			// This is expected in some situations.
			return null;
		}
	}

	@Override
	public Collection<OptoutReason> findOptoutReasons() {
		final Query q = this.entityManager
				.createNamedQuery("OptoutReason.findAll");
		return q.getResultList();
	}

	@Override
	public ConsentDirective findPatientActiveConsentDirective(final Collection<String> patientIens, final ConsentType consentType) {
		try {
            //get the last millisecond from yesterday because we want to get the active consent including today at midnight (12:00 AM)
            Date startOfToday = DateUtils.truncate(new Date(), Calendar.DAY_OF_MONTH);
            Date lastMillisecondOfYesterday = DateUtils.addMilliseconds(startOfToday, -1);

            final Query q = this.entityManager.createNamedQuery("ConsentDirective.findActiveByConsentType");
			
            q.setParameter("patientIens", patientIens);
			q.setParameter("consentType", consentType);
			Collection<ConsentDirective> cds = q.getResultList();
            
			for(ConsentDirective cd : cds) {
				if(cd.getExpirationDate()== null || cd.getExpirationDate().after(lastMillisecondOfYesterday)) {
					return cd;
				}
			}
            
			return null;
		} catch (final NoResultException nre) {
			// This is expected in some situations.
			return null;
		}
	}

	@Override
	public Collection<ConsentDirective> findPatientActiveConsentDirectives(
			final Collection<String> patientIens) {
		try {
			final Query q = this.entityManager
					.createNamedQuery("ConsentDirective.findActive");
			q.setParameter("patientIens", patientIens);
			return q.getResultList();
		} catch (final NoResultException nre) {
			// This is expected in some situations.
			return null;
		}
	}

	@Override
	public Collection<ConsentDirective> findPatientConsentDirectives(
			final Collection<String> patientIens) {
		final Query q = this.entityManager
				.createNamedQuery("ConsentDirective.findAllByPatient");
		q.setParameter("patientIens", patientIens);
		return q.getResultList();
	}

	@Override
	public Collection<ConsentDirective> findExpiringPatientConsentDirectives(int daysTilExpiration, int fromPage, int toPage, final Collection<String> patientIens) {
		final Query q = this.entityManager.createNamedQuery("ConsentDirective.findExpiringConsentDirectives");
		q.setParameter("days_until_expiration", new Double(daysTilExpiration));
		q.setParameter("patient_iens", patientIens);
		q.setParameter("from_page", new Integer(fromPage));
		q.setParameter("to_page", new Integer(toPage));
		return q.getResultList();
	}
	
	@Override
	public Collection<ConsentDirective> findAllExpiringPatientConsentDirectives(int daysTilExpiration, int fromPage, int toPage){
		final Query q = this.entityManager.createNamedQuery("ConsentDirective.findAllExpiringConsentDirectives");
		q.setParameter("days_until_expiration", (double)daysTilExpiration);
		//q.setParameter("consent_type", 104);//HARD-CODED TO CONSENT TYPE OPT-IN
		q.setParameter("from_page", fromPage);
		q.setParameter("to_page", toPage);
		return q.getResultList();
	}
    
    @Override
	public Collection<ConsentDirective> findAllExpiringPatientConsentDirectives(Date startDate, Date endDate, int fromPage, int toPage){

        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        
		final Query q = this.entityManager.createNamedQuery("ConsentDirective.findAllExpiringConsentDirectivesWithDates");
		q.setParameter("start_date", dateFormat.format(startDate));
		q.setParameter("end_date", dateFormat.format(endDate));
		q.setParameter("from_page", fromPage);
		q.setParameter("to_page", toPage);
		return q.getResultList();
	}
    
    @Override
	public Collection<DetailedConsentDirective> findAllExpiringDetailedConsentDirectives(
            Date startDate, Date endDate, String facilityStation, String consentTypeName, String userId, int fromPage, int toPage, String sortColumn, 
            String sortDirection, int patientTypes){

        PatientConsentDirDAO.SearchRequest req = new PatientConsentDirDAO().new SearchRequest();
        req.patientTypes = patientTypes;
        req.stationNumbers = facilityStation;
        
        final HashMap<String, Object> queryParams = new HashMap<String, Object>();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        String queryString = DetailedConsentDirective.constructQuery(req, queryParams);
        Query q = this.entityManager.createNativeQuery(queryString, DetailedConsentDirective.class);
        
        if (startDate == null) {
            q.setParameter("start_date", null);
        } else {
            q.setParameter("start_date", dateFormat.format(startDate));
        }
        if (startDate == null) {
            q.setParameter("end_date", null);
        } else {
            q.setParameter("end_date", dateFormat.format(endDate));
        }
        
        if (consentTypeName.equals("NwHIN Authorization") || consentTypeName.isEmpty()) {
            q.setParameter("eheath_consent",  "100");
        }else{
            q.setParameter("eheath_consent",  "");
        }
        
        if (consentTypeName.equals("SSA Authorization")|| consentTypeName.isEmpty()) {
            q.setParameter("ssa_consent", "102");
        }else{
            q.setParameter("ssa_consent",  "");
        }
       
        
        if(userId.isEmpty()){
            q.setParameter("user_id", null);
        }
        else{
            q.setParameter("user_id", userId);
        }
        q.setParameter("from_record", fromPage);
        q.setParameter("to_record", toPage);

        // Set query parameters
        DAOUtil.setQueryParams(q, queryParams);

		return q.getResultList();
	}
    
    @Override
    public Collection<FacilityOptInConsent> findAuthorizedConsentForOptInSummary(){
        final Query q = this.entityManager.createNamedQuery("FacilityOptInConsent.findAuthorizedConsentInformation");
        return q.getResultList();
    }
	
	@Override
	public Collection<ConsentDirective> findAllFutureExpiringPatientConsentDirectives(int fromPage, int toPage){
            final Query q;
            if(fromPage == 0 && toPage == 0){
                q = this.entityManager.createNamedQuery("ConsentDirective.findAllFutureExpiringConsentDirectives");
            }
            else{
                q = this.entityManager.createNamedQuery("ConsentDirective.findAllFutureExpiringConsentDirectivesPage");
                q.setParameter("from_page", fromPage);
		q.setParameter("to_page", toPage);
            }
            
		return q.getResultList();
	}

	public int getConsentDirectiveCount(final EntityManager em) {
		final Query q = em
				.createQuery("select COUNT(cd.*) from ConsentDirective cd");
		return ((Long) q.getSingleResult()).intValue();
	}

	@Override
	public OptoutReason getOptoutReasonByText(final String text) {
		final Query q = this.entityManager
				.createNamedQuery("OptoutReason.findByText");
		q.setParameter("text", text);
		return (OptoutReason) q.getSingleResult();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

	@Override
	public PurposeOfUse findPurposeOfUseByValue(String pouValue) {
		try {
			final Query q = this.entityManager
					.createNamedQuery("PurposeOfUse.findByPouValue");
			q.setParameter("pouValue", pouValue);
			return (PurposeOfUse) q.getSingleResult();
		} catch (final NoResultException nre) {
			// This is expected in some situations.
			return null;
		}
	}
    
    @Override
    public Collection<ConsentDirective> findRecentlyExpiredConsent() {
        try {
            final Query q = this.entityManager.createNamedQuery("ConsentDirective.findRecentlyExpiredConsent");
            return q.getResultList();
        } catch (final NoResultException nre) {
            // This is expected when there is nothing recently expired.
            return null;
        }
    }
    
}
