/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.AuthorityControllerInterface;
import gov.va.nvap.svc.consentmgmt.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Authority;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author vhaislegberb
 */
public class AuthorityJpaController implements AuthorityControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager em;

	public void create(final Authority authority) {
		this.em.persist(authority);
	}

	public void destroy(final Long id) throws NonexistentEntityException {

		Authority authority;
		try {
			authority = this.em.getReference(Authority.class, id);
			authority.getAuthorityId();
		} catch (final EntityNotFoundException enfe) {
			throw new NonexistentEntityException("The authority with id " + id
					+ " no longer exists.", enfe);
		}
		this.em.remove(authority);

	}

	public void edit(Authority authority) throws NonexistentEntityException,
			Exception {
		try {
			authority = this.em.merge(authority);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = authority.getAuthorityId();
				if (this.findAuthority(id) == null) {
					throw new NonexistentEntityException(
							"The authority with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	public Authority findAuthority(final Long id) {
		return this.em.find(Authority.class, id);
	}

	@Override
	public Authority findAuthortiyByOid(final String oid) {
		try {
			final Query q = this.em.createNamedQuery("Authority.findByOid");
			q.setParameter("oid", oid);
			return (Authority) q.getSingleResult();
		} catch (final NoResultException nre) {
			// expected
			return null;
		}
	}

	public void setEntityManager(final EntityManager em) {
		this.em = em;
	}

}
