package gov.va.nvap.svc.consentmgmt.jpa;

import gov.va.nvap.svc.consentmgmt.AnnouncementOrgControllerInterface;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementBatchSummary;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 * 
 * @author Zack Peterson
 */
public class AnnouncementOrgJpaController implements
		AnnouncementOrgControllerInterface {

	@PersistenceContext(name = "VapEntityManager")
	private EntityManager entityManager;

	@Override
	public void create(final AnnouncementOrg announcementOrg)
			throws PreexistingEntityException, Exception {
		try {
			this.entityManager.persist(announcementOrg);
		} catch (final Exception ex) {
			if (this.findAnnouncementOrgById(announcementOrg.getAnnouncementOrgId()) != null) {
				throw new PreexistingEntityException("AnnouncementOrg "
						+ announcementOrg + " already exists.", ex);
			}
			throw ex;
		}
	}
    
    @Override
    public void removeByAnnouncement (Announcement announcement) {
        final Query q = this.entityManager
				.createNamedQuery("Announcement.deleteByAnnouncement");
		q.setParameter("announcement", announcement);
		q.executeUpdate();
    }

	@Override
	public void edit(AnnouncementOrg announcementOrg)
			throws NonexistentEntityException, Exception {
		try {
			announcementOrg = this.entityManager.merge(announcementOrg);
		} catch (final Exception ex) {
			final String msg = ex.getLocalizedMessage();
			if ((msg == null) || (msg.length() == 0)) {
				final Long id = announcementOrg.getAnnouncementOrgId();
				if (this.findAnnouncementOrgById(id) == null) {
					throw new NonexistentEntityException(
							"The AnnouncementOrg with id " + id
									+ " no longer exists.");
				}
			}
			throw ex;
		}
	}

	@Override
	public AnnouncementOrg findAnnouncementOrgById(final Long id) {
		return this.entityManager.find(AnnouncementOrg.class, id);
	}

	@Override
	public List<AnnouncementOrg> findAllAnnouncementOrgs() {
		return this.findAllAnnouncementOrgs(true, -1, -1);
	}

	private List<AnnouncementOrg> findAllAnnouncementOrgs(final boolean all,
			final int maxResults, final int firstResult) {
		final Query q = this.entityManager
				.createNamedQuery("AnnouncementOrg.findAll");
		if (!all) {
			q.setMaxResults(maxResults);
			q.setFirstResult(firstResult);
		}
		return q.getResultList();
	}

	public List<AnnouncementOrg> findAllAnnouncementOrgs(final int maxResults,
			final int firstResult) {
		return this.findAllAnnouncementOrgs(false, maxResults, firstResult);
	}
    
    @Override
    public List<AnnouncementOrg> findAnnouncementOrgsByAnnouncement(final Announcement announcement) {
        final Query q = this.entityManager.createNamedQuery("AnnouncementOrg.findByAnnouncement");
        q.setParameter("announcement", announcement);
        return q.getResultList();
    }

	public int getAnnouncementOrgCount() {
		final Query q = this.entityManager
				.createQuery("select count() from AnnouncementOrg");
		return ((Long) q.getSingleResult()).intValue();
	}

	public void setEntityManager(final EntityManager entityManager) {
		this.entityManager = entityManager;
	}

    @Override
	public List<AnnouncementBatchSummary> retrieveBatchSummaries (
			final List<String> batchIds) {
		final Query q = this.entityManager.createNamedQuery("AnnouncementOrg.batchSummary");
		q.setParameter("batchIds", batchIds);
		return q.getResultList();
	}
}
