/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocument;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;

import java.util.Collection;

/**
 * 
 * @author vhaislegberb
 */
public interface PatientDocumentControllerInterface {

	void create(PatientDocument patientDocument)
			throws PreexistingEntityException, Exception;

	void edit(PatientDocument patientDocument)
			throws NonexistentEntityException, Exception;

	Collection<PatientDocument> findByConsentDirective(
			ConsentDirective consentDirective);

	PatientDocument findByConsentDirectiveAndType(
			ConsentDirective consentDirective,
			PatientDocumentType patientDocumentType);

	PatientDocument findPatientDocument(Long id);

	Collection<PatientDocumentType> findPatientDocumentTypes();

}
