/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.privacy.ConsentDirectiveDetailedExpirationRequest;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.Announcement;
import gov.va.nvap.svc.consentmgmt.stub.adapter.announce.data.AnnouncementOrg;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ExpiringConsentConfiguration;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import gov.va.nvap.svc.consentmgmt.stub.data.FacilityOptInConsent;
import gov.va.nvap.svc.consentmgmt.stub.data.FunctionalRole;
import gov.va.nvap.svc.consentmgmt.stub.data.Location;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocument;
import gov.va.nvap.svc.consentmgmt.stub.data.PatientDocumentType;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;
import java.util.Collection;

/**
 *
 * @author vhaislegberb
 */
public interface PIPInterface {

    /**
     * Gets the expiring consent directives .
     *
     * @param patientIens restricts the expiring consent directives to consent directives tied to this collection, or returns all expiring
     * consent directives across all patients if null.
     * @param consentDirectiveExpirationRequest
     * @return a collection of ConsentDirectives that will expire within daysTilExpiration days
     */
    Collection<ConsentDirective> getExpiringPatientConsentDirectives(Collection<String> patientIens,
        ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest);

    /**
     * Gets the expiring consent directives with some demographic information.
     *
     * @param consentDirectiveExpirationRequest
     * @return a collection of DetailedConsentDirectives that will expire within daysTilExpiration days
     */
    Collection<DetailedConsentDirective> getExpiringPatientDetailedConsentDirectives(
        ConsentDirectiveDetailedExpirationRequest consentDirectiveExpirationRequest);

    /**
     * Gets the active consent directive for the patient. The current implementation is only supports a single active consent directive at a
     * time.
     *
     * @param patientIens The known enterprise identifiers for the patient.
     * @param consentType The specific type of consent directive being requested.
     * @return The active consent directive.
     */
    ConsentDirective getActiveConsentDirective(Collection<String> patientIens,
        ConsentType consentType);

    /**
     * Gets the list of active consent directives known for the patient.
     *
     * @param patientIens The known patient enterprise identifiers for the patient.
     * @return The active consent directive.
     */
    Collection<ConsentDirective> getActiveConsentDirectives(
        Collection<String> patientIens);

    /**
     * Gets the list of allowed functional roles supported by the enterprise.
     *
     * @return The list of allowed functional roles.
     */
    Collection<FunctionalRole> getAllowedFunctionalRoles();

    /**
     * Gets the list of current partner organizations sharing information on the NwHIN.
     *
     * @return The list of allowed organizations.
     */
    Collection<Organization> getAllowedOrganizations();

    /**
     * Gets if a partner organization is a trusted clinical source or not.
     *
     * @return If a partner organization is a trusted clinical source or not.
     */
    Boolean getIsOrganizationTrustedSource(String organizationId);

    /**
     * Gets the list of current non-consumer-only partner organizations sharing information on the NwHIN.
     *
     * @return The list of allowed non consumer only organizations.
     */
    Collection<Organization> getAllowedNonConsumerOnlyOrganizations();

    /**
     * Gets the list of current consumer-only partner organizations sharing information on the NwHIN.
     *
     * @return The list of allowed consumer only organizations.
     */
    Collection<Organization> getAllowedConsumerOnlyOrganizations();

    /**
     * Gets the list of allowed purposes of use currently supported by the enterprise.
     *
     * @return The list of purposes of uses.
     */
    Collection<PurposeOfUse> getAllowedPurposeOfUse();

    /**
     * Gets the list of VistA Facilities that are currently allowed to participate in the NwHIN exchange.
     *
     * @return The list of facilities currently participating.
     */
    Collection<Facility> getAllowedVistAFacilities();

    /**
     * Returns the assigning authority name given the OID.
     *
     * @param oid The OID of the assigning authority.
     * @return The name of the assigning authority.
     */
    String getAuthorityName(String oid);

    /**
     * Gets the single patient document of a particular type associated with the consent directive (i.e. OPT-IN / OPT-OUT)
     *
     * @param consentDirective The consent directive that the document is associated with.
     * @param patientDocumentType The type of document being requested.
     * @return The patient document of the specified type associated with the consent directive.
     */
    PatientDocument getConsentDirectiveDocumentByType(
        ConsentDirective consentDirective,
        PatientDocumentType patientDocumentType);

    /**
     * Gets the list of documents associated with a consent directive.
     *
     * @param consentDirective The consent directive that the documents are associated with.
     * @return The list of all documents associated with a consent directive.
     */
    Collection<PatientDocument> getConsentDirectiveDocuments(
        ConsentDirective consentDirective);

    /**
     * Returns a historical list of the patient's consent history.
     *
     * @param patientIens The known national patient identifiers of the patient whose consent history is being requested.
     * @return The consent history of the patient.
     */
    Collection<ConsentDirective> getConsentHistory(Collection<String> patientIen);

    /**
     * Gets the consent type that corresponds to the name.
     *
     * @param name The name of the consent type requested.
     * @return The consent type.
     */
    public ConsentType getConsentTypeByName(String name);

    /**
     * Gets a VA Facility by Station Number..
     *
     * @param id A station Number such as 983, assigned by ???
     * @return A Facility corresponding to Station Number.
     */
    public Facility getFacilityByStationId(String id);

    /**
     * Gets a VA Location by Code..
     *
     * @param locationCode A location code such as ISL, ISW, SLC etc.
     * @return A location corresponding to location codes.
     */
    public Location getLocationByCode(String locationCode);

    /**
     * Gets the list of available opt-out reasons that the user has available to choose from when processing an opt-out or revocation
     * request.
     *
     * @return The list of allowed out-out reasons.
     */
    Collection<OptoutReason> getOptoutReasons();

    /**
     * Gets the organization with the given identifier; otherwise returns null.
     *
     * @param id The identifier of the organization to be retrieved.
     * @return The organization with the given identifier.
     */
    public Organization getOrganizationById(Long id);

    /**
     * Gets the organization with the given object identifier; otherwise returns null.
     *
     * @param id The object identifier of the organization to be retrieved.
     * @return The organization with the given object identifier.
     */
    public Organization getOrganizationByOid(String orgOid);

    /**
     * Get the standardized patient document types.
     *
     * @return the patient document types
     */
    Collection<PatientDocumentType> getPatientDocumentTypes();

    /**
     * A course grained method for getting all constraints required to perform a policy check within the policy decision point engine.
     *
     * @param patientIens The known enterprise identifiers for the patient.
     * @return The single policy constraint for the patient.
     */
    PolicyConstraints getPolicyConstraints(Collection<String> patientIens,
        ConsentType consentType);

    /**
     * Stores the consent directive.
     *
     * @param consentDirective The consent directive to be persisted.
     */
    void storeConsentDirective(ConsentDirective consentDirective);

    /**
     * Stores the organization into the persistent organization store.
     *
     * @param organization The organization to be persisted.
     */
    public void storeOrganization(Organization organization);

    /**
     * Stores the patient document in the persistent store.
     *
     * @param patientDocument The document to store.
     */
    void storePatientDocument(PatientDocument patientDocument);

    /**
     * Update the patient document in the persistent store.
     *
     * @param patientDocument The document to store.
     */
    void updatePatientDocument(PatientDocument patientDocument);

    PurposeOfUse getPurposeOfUseByValue(final String name);

    public ExpiringConsentConfiguration getExpiringConsentConfiguration();

    public void updateExpiringConsentConfiguration(ExpiringConsentConfiguration config);

    Collection<FacilityOptInConsent> getAuthorizedConsentForSummary();

    public Collection<AnnouncementOrg> getAllAnnouncementOrgs();

    public void storeAnnouncementOrg(AnnouncementOrg announceOrg);

    public void updateAnnouncementOrg(AnnouncementOrg announceOrg);

    public Collection<AnnouncementOrg> getAnnouncementOrgsByAnnouncement(Announcement announcement);

    public Collection<ConsentDirective> getRecentlyExpiredConsent();

    public ConsentDirective getConsentDirective(Long id);

    public Facility getFacilityByName(String facilityName);
}
