/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Organization;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;

/**
 * 
 * @author vhaislegberb
 */
public interface OrganizationsControllerInterface {

	void create(Organization organizations) throws PreexistingEntityException,
			Exception;

	void edit(Organization organizations) throws NonexistentEntityException,
			Exception;

	Organization findOrganization(Long id);

	Organization findOrganizationByName(String orgName);

	public Organization findOrganizationByOid(String oid);

	List<Organization> findOrganizationsEntities(EntityManager em);

	List<Organization> getActiveOrganizations();

	public Collection<Organization> getActiveNonConsumerOnlyOrganizations();

	public Collection<Organization> getActiveConsumerOnlyOrganizations();
    
    public Boolean getIsOrganizationTrustedSource(String organizationId);

}
