/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import gov.va.nvap.svc.consentmgmt.stub.data.Location;

import java.util.Collection;
import java.util.List;

/**
 * 
 * @author Anand Sastry
 */
public interface LocationControllerInterface {

	void create(Location location) throws PreexistingEntityException, Exception;

	void edit(Location location) throws NonexistentEntityException, Exception;

	public Collection<Location> findActiveLocations();

	public Collection<Location> findByFacility(Facility facility);

	public Location findByLocationCode(String locationCode);

	Location findLocation(Long id);

	List<Location> findLocationEntities();

	List<Location> findLocationEntities(int maxResults, int firstResult);

}
