/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.Facility;
import java.util.Collection;
import java.util.List;

/**
 *
 * @author vhaislegberb
 */
public interface FacilityControllerInterface {

    void create(Facility facility) throws PreexistingEntityException, Exception;

    void edit(Facility facility) throws NonexistentEntityException, Exception;

    public Collection<Facility> findAllowedFacilities();

    Facility findFacility(Long id);

    public Facility findFacilityByStation(String stationId);

    List<Facility> findFacilityEntities();

    List<Facility> findFacilityEntities(int maxResults, int firstResult);

    String findFacilityStationByName(String facilityName);

    Facility findFacilityByName(String facilityName);

}
