/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.nvap.svc.consentmgmt;

import gov.va.nvap.svc.consentmgmt.jpa.exceptions.IllegalOrphanException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.NonexistentEntityException;
import gov.va.nvap.svc.consentmgmt.jpa.exceptions.PreexistingEntityException;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.ConsentType;
import gov.va.nvap.svc.consentmgmt.stub.data.DetailedConsentDirective;
import gov.va.nvap.svc.consentmgmt.stub.data.FacilityOptInConsent;
import gov.va.nvap.svc.consentmgmt.stub.data.OptoutReason;
import gov.va.nvap.svc.consentmgmt.stub.data.PurposeOfUse;

import java.util.Collection;
import java.util.Date;

/**
 *
 * @author vhaislegberb
 */
public interface ConsentDirectiveControllerInterface {

	void create(ConsentDirective consentDirective)
			throws PreexistingEntityException, Exception;

	void edit(ConsentDirective consentDirective) throws IllegalOrphanException,
			NonexistentEntityException, Exception;

	ConsentDirective findConsentDirective(Long id);

	ConsentType findConsentTypeByName(String name);

	PurposeOfUse findPurposeOfUseByValue(String name);

	Collection<OptoutReason> findOptoutReasons();

	ConsentDirective findPatientActiveConsentDirective(
			Collection<String> patientIens, ConsentType consentType);

	Collection<ConsentDirective> findPatientActiveConsentDirectives(
			Collection<String> patientIens);

	Collection<ConsentDirective> findPatientConsentDirectives(
			Collection<String> patientIens);

	OptoutReason getOptoutReasonByText(String text);

	Collection<ConsentDirective> findExpiringPatientConsentDirectives(int daysTilExpiration, int fromPage, int toPage, final Collection<String> patientIens);
	
	Collection<ConsentDirective> findAllExpiringPatientConsentDirectives(int daysTilExpiration, int fromPage, int toPage);
    
    Collection<ConsentDirective> findAllExpiringPatientConsentDirectives(Date startDate, Date endDate, int fromPage, int toPage);
    
    Collection<DetailedConsentDirective> findAllExpiringDetailedConsentDirectives(Date startDate, Date endDate, String facilityStation, String consentTypeName, String userId, int fromPage, int toPage, String sortColumn, String sortDirection, int patientTypes);
	
	Collection<ConsentDirective> findAllFutureExpiringPatientConsentDirectives(int fromPage, int toPage);

    Collection<FacilityOptInConsent> findAuthorizedConsentForOptInSummary();
    
    Collection<ConsentDirective> findRecentlyExpiredConsent();
}
